/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queryparser.flexible.standard;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;

public final class QueryParserUtil {
    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws QueryNodeException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(analyzer);
        for (int i = 0; i < fields.length; ++i) {
            Query q = qp.parse(queries[i], fields[i]);
            if (q == null) continue;
            bQuery.add(q, BooleanClause.Occur.SHOULD);
        }
        return bQuery.build();
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws QueryNodeException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(analyzer);
        for (int i = 0; i < fields.length; ++i) {
            Query q = qp.parse(query, fields[i]);
            if (q == null) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery.build();
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws QueryNodeException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(analyzer);
        for (int i = 0; i < fields.length; ++i) {
            Query q = qp.parse(queries[i], fields[i]);
            if (q == null) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery.build();
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

