/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConjunctionDISI;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

class ConjunctionScorer
extends Scorer {
    final DocIdSetIterator disi;
    final Scorer[] scorers;
    final float coord;

    ConjunctionScorer(Weight weight, Collection<Scorer> required, Collection<Scorer> scorers, float coord) {
        super(weight);
        assert (required.containsAll(scorers));
        this.coord = coord;
        this.disi = ConjunctionDISI.intersectScorers(required);
        this.scorers = scorers.toArray(new Scorer[scorers.size()]);
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return TwoPhaseIterator.unwrap(this.disi);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        double sum = 0.0;
        for (Scorer scorer : this.scorers) {
            sum += (double)scorer.score();
        }
        return this.coord * (float)sum;
    }

    @Override
    public int freq() {
        return this.scorers.length;
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>();
        for (Scorer scorer : this.scorers) {
            children.add(new Scorer.ChildScorer(scorer, "MUST"));
        }
        return children;
    }

    static final class DocsAndFreqs {
        final long cost;
        final DocIdSetIterator iterator;
        int doc = -1;

        DocsAndFreqs(DocIdSetIterator iterator) {
            this.iterator = iterator;
            this.cost = iterator.cost();
        }
    }
}

