/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.AutomatonQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DisjunctionMaxQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FuzzyQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.PrefixQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TermRangeQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanBoostQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanNearQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanNotQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanOrQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.CharsRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.UnicodeUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Automata;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Operations;

class MultiTermHighlighting {
    private MultiTermHighlighting() {
    }

    public static CharacterRunAutomaton[] extractAutomata(Query query, Predicate<String> fieldMatcher, boolean lookInSpan, Function<Query, Collection<Query>> preRewriteFunc) {
        AutomatonQuery aq;
        ArrayList<CharacterRunAutomaton> list = new ArrayList<CharacterRunAutomaton>();
        Collection<Query> customSubQueries = preRewriteFunc.apply(query);
        if (customSubQueries != null) {
            for (Query sub : customSubQueries) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : (BooleanQuery)query) {
                if (clause.isProhibited()) continue;
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(clause.getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (query instanceof ConstantScoreQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((ConstantScoreQuery)query).getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (query instanceof BoostQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((BoostQuery)query).getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (query instanceof DisjunctionMaxQuery) {
            for (Query sub : ((DisjunctionMaxQuery)query).getDisjuncts()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (lookInSpan && query instanceof SpanOrQuery) {
            for (SpanQuery sub : ((SpanOrQuery)query).getClauses()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (lookInSpan && query instanceof SpanNearQuery) {
            for (SpanQuery sub : ((SpanNearQuery)query).getClauses()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (lookInSpan && query instanceof SpanNotQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanNotQuery)query).getInclude(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (lookInSpan && query instanceof SpanPositionCheckQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanPositionCheckQuery)query).getMatch(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (lookInSpan && query instanceof SpanBoostQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanBoostQuery)query).getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (lookInSpan && query instanceof SpanMultiTermQueryWrapper) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanMultiTermQueryWrapper)query).getWrappedQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (query instanceof PrefixQuery) {
            final PrefixQuery pq = (PrefixQuery)query;
            Term prefix = pq.getPrefix();
            if (fieldMatcher.test(prefix.field())) {
                list.add(new CharacterRunAutomaton(Operations.concatenate(Automata.makeString(prefix.text()), Automata.makeAnyString())){

                    @Override
                    public String toString() {
                        return pq.toString();
                    }
                });
            }
        } else if (query instanceof FuzzyQuery) {
            final FuzzyQuery fq = (FuzzyQuery)query;
            if (fieldMatcher.test(fq.getField())) {
                int cp;
                String utf16 = fq.getTerm().text();
                int[] termText = new int[utf16.codePointCount(0, utf16.length())];
                int j = 0;
                for (int i = 0; i < utf16.length(); i += Character.charCount(cp)) {
                    termText[j++] = cp = utf16.codePointAt(i);
                }
                int termLength = termText.length;
                int prefixLength = Math.min(fq.getPrefixLength(), termLength);
                String suffix = UnicodeUtil.newString(termText, prefixLength, termText.length - prefixLength);
                LevenshteinAutomata builder = new LevenshteinAutomata(suffix, fq.getTranspositions());
                String prefix = UnicodeUtil.newString(termText, 0, prefixLength);
                Automaton automaton = builder.toAutomaton(fq.getMaxEdits(), prefix);
                list.add(new CharacterRunAutomaton(automaton){

                    @Override
                    public String toString() {
                        return fq.toString();
                    }
                });
            }
        } else if (query instanceof TermRangeQuery) {
            final TermRangeQuery tq = (TermRangeQuery)query;
            if (fieldMatcher.test(tq.getField())) {
                final CharsRef lowerBound = tq.getLowerTerm() == null ? null : new CharsRef(tq.getLowerTerm().utf8ToString());
                final CharsRef upperBound = tq.getUpperTerm() == null ? null : new CharsRef(tq.getUpperTerm().utf8ToString());
                final boolean includeLower = tq.includesLower();
                final boolean includeUpper = tq.includesUpper();
                final CharsRef scratch = new CharsRef();
                final Comparator<CharsRef> comparator = CharsRef.getUTF16SortedAsUTF8Comparator();
                list.add(new CharacterRunAutomaton(Automata.makeEmpty()){

                    @Override
                    public boolean run(char[] s, int offset, int length) {
                        int cmp;
                        scratch.chars = s;
                        scratch.offset = offset;
                        scratch.length = length;
                        if (lowerBound != null && ((cmp = comparator.compare(scratch, lowerBound)) < 0 || !includeLower && cmp == 0)) {
                            return false;
                        }
                        return upperBound == null || (cmp = comparator.compare(scratch, upperBound)) <= 0 && (includeUpper || cmp != 0);
                    }

                    @Override
                    public String toString() {
                        return tq.toString();
                    }
                });
            }
        } else if (query instanceof AutomatonQuery && fieldMatcher.test((aq = (AutomatonQuery)query).getField())) {
            list.add(new CharacterRunAutomaton(aq.getAutomaton()){

                @Override
                public String toString() {
                    return aq.toString();
                }
            });
        }
        return list.toArray(new CharacterRunAutomaton[list.size()]);
    }
}

