/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ObjectHashSet;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchGenerationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.Index;

public class PutMappingRequest
extends AcknowledgedRequest<PutMappingRequest>
implements IndicesRequest.Replaceable {
    private static ObjectHashSet<String> RESERVED_FIELDS = ObjectHashSet.from("_uid", "_id", "_type", "_source", "_all", "_analyzer", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl", "_field_names");
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private String type;
    private String source;
    private boolean updateAllTypes = false;
    private Index concreteIndex;

    public PutMappingRequest() {
    }

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("mapping type is missing", validationException);
        } else if (this.type.isEmpty()) {
            validationException = ValidateActions.addValidationError("mapping type is empty", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("mapping source is missing", validationException);
        } else if (this.source.isEmpty()) {
            validationException = ValidateActions.addValidationError("mapping source is empty", validationException);
        }
        if (this.concreteIndex != null && this.indices != null && this.indices.length > 0) {
            validationException = ValidateActions.addValidationError("either concrete index or unresolved indices can be set, concrete index: [" + this.concreteIndex + "] and indices: " + Arrays.asList(this.indices), validationException);
        }
        return validationException;
    }

    @Override
    public PutMappingRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public PutMappingRequest setConcreteIndex(Index index) {
        Objects.requireNonNull(this.indices, "index must not be null");
        this.concreteIndex = index;
        return this;
    }

    public Index getConcreteIndex() {
        return this.concreteIndex;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String type() {
        return this.type;
    }

    public PutMappingRequest type(String type) {
        this.type = type;
        return this;
    }

    public String source() {
        return this.source;
    }

    public PutMappingRequest source(Object ... source) {
        return this.source(PutMappingRequest.buildFromSimplifiedDef(this.type, source));
    }

    public static XContentBuilder buildFromSimplifiedDef(String type, Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("mapping source must be pairs of fieldnames and properties definition.");
        }
        try {
            String[] s2;
            String[] s1;
            String fieldName;
            int i;
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            if (type != null) {
                builder.startObject(type);
            }
            for (i = 0; i < source.length; ++i) {
                if (!RESERVED_FIELDS.contains(fieldName = source[i++].toString())) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.startObject("properties");
            for (i = 0; i < source.length; ++i) {
                if (RESERVED_FIELDS.contains(fieldName = source[i++].toString())) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.endObject();
            if (type != null) {
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to generate simplified mapping definition", e);
        }
    }

    public PutMappingRequest source(XContentBuilder mappingBuilder) {
        try {
            return this.source(mappingBuilder.string(), mappingBuilder.contentType());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to build json for mapping request", e);
        }
    }

    public PutMappingRequest source(Map mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(mappingSource);
            return this.source(builder.string(), XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + mappingSource + "]", e);
        }
    }

    @Deprecated
    public PutMappingRequest source(String mappingSource) {
        return this.source(mappingSource, XContentFactory.xContentType(mappingSource));
    }

    public PutMappingRequest source(String mappingSource, XContentType xContentType) {
        return this.source(new BytesArray(mappingSource), xContentType);
    }

    public PutMappingRequest source(BytesReference mappingSource, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        try {
            this.source = XContentHelper.convertToJson(mappingSource, false, false, xContentType);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to convert source to json", e);
        }
    }

    public boolean updateAllTypes() {
        return this.updateAllTypes;
    }

    public PutMappingRequest updateAllTypes(boolean updateAllTypes) {
        this.updateAllTypes = updateAllTypes;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.type = in.readOptionalString();
        this.source = in.readString();
        if (in.getVersion().before(Version.V_5_3_0)) {
            this.source = XContentHelper.convertToJson(new BytesArray(this.source), false, false, XContentFactory.xContentType(this.source));
        }
        this.updateAllTypes = in.readBoolean();
        this.readTimeout(in);
        this.concreteIndex = in.readOptionalWriteable(Index::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.type);
        out.writeString(this.source);
        out.writeBoolean(this.updateAllTypes);
        this.writeTimeout(out);
        out.writeOptionalWriteable(this.concreteIndex);
    }
}

