/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put;

import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.Index;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexNotFoundException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportPutMappingAction
extends TransportMasterNodeAction<PutMappingRequest, PutMappingResponse> {
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public TransportPutMappingAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataMappingService metaDataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/mapping/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutMappingRequest::new);
        this.metaDataMappingService = metaDataMappingService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected PutMappingResponse newResponse() {
        return new PutMappingResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = request.getConcreteIndex() == null ? this.indexNameExpressionResolver.concreteIndexNames(state, request) : new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(final PutMappingRequest request, ClusterState state, final ActionListener<PutMappingResponse> listener) {
        try {
            Index[] indexArray;
            if (request.getConcreteIndex() == null) {
                indexArray = this.indexNameExpressionResolver.concreteIndices(state, request);
            } else {
                Index[] indexArray2 = new Index[1];
                indexArray = indexArray2;
                indexArray2[0] = request.getConcreteIndex();
            }
            final Index[] concreteIndices = indexArray;
            PutMappingClusterStateUpdateRequest updateRequest = ((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).type(request.type()).updateAllTypes(request.updateAllTypes()).source(request.source());
            this.metaDataMappingService.putMapping(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                @Override
                public void onResponse(ClusterStateUpdateResponse response) {
                    listener.onResponse(new PutMappingResponse(response.isAcknowledged()));
                }

                @Override
                public void onFailure(Exception t) {
                    TransportPutMappingAction.this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}], type [{}]", (Object)concreteIndices, (Object)request.type()), (Throwable)t);
                    listener.onFailure(t);
                }
            });
        }
        catch (IndexNotFoundException ex) {
            this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}], type [{}]", (Object)request.indices(), (Object)request.type()), (Throwable)ex);
            throw ex;
        }
    }
}

