/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.IntArrayList;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.GetResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.MultiGetResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;

public class MultiGetShardResponse
extends ActionResponse {
    IntArrayList locations = new IntArrayList();
    List<GetResponse> responses = new ArrayList<GetResponse>();
    List<MultiGetResponse.Failure> failures = new ArrayList<MultiGetResponse.Failure>();

    MultiGetShardResponse() {
    }

    public void add(int location, GetResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiGetResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.responses = new ArrayList<GetResponse>(size);
        this.failures = new ArrayList<MultiGetResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                GetResponse response = new GetResponse();
                response.readFrom(in);
                this.responses.add(response);
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(MultiGetResponse.Failure.readFailure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

