/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.gateway.GatewayService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.IndexTemplateMissingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

public class TemplateUpgradeService
extends AbstractComponent
implements ClusterStateListener {
    private final UnaryOperator<Map<String, IndexTemplateMetaData>> indexTemplateMetaDataUpgraders;
    public final ClusterService clusterService;
    public final ThreadPool threadPool;
    public final Client client;
    private final AtomicInteger updatesInProgress = new AtomicInteger();
    private ImmutableOpenMap<String, IndexTemplateMetaData> lastTemplateMetaData;
    private static final ToXContent.Params PARAMS = new ToXContent.MapParams(Collections.singletonMap("reduce_mappings", "true"));

    public TemplateUpgradeService(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, Collection<UnaryOperator<Map<String, IndexTemplateMetaData>>> indexTemplateMetaDataUpgraders) {
        super(settings);
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexTemplateMetaDataUpgraders = templates -> {
            Map upgradedTemplates = new HashMap(templates);
            for (UnaryOperator upgrader : indexTemplateMetaDataUpgraders) {
                upgradedTemplates = (Map)upgrader.apply(upgradedTemplates);
            }
            return upgradedTemplates;
        };
        clusterService.addListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (this.updatesInProgress.get() > 0) {
            return;
        }
        ImmutableOpenMap<String, IndexTemplateMetaData> templates = state.getMetaData().getTemplates();
        if (templates == this.lastTemplateMetaData) {
            return;
        }
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        this.lastTemplateMetaData = templates;
        Optional<Tuple<Map<String, BytesReference>, Set<String>>> changes = this.calculateTemplateChanges(templates);
        if (changes.isPresent() && this.updatesInProgress.compareAndSet(0, changes.get().v1().size() + changes.get().v2().size())) {
            this.logger.info("Starting template upgrade to version {}, {} templates will be updated and {} will be removed", (Object)Version.CURRENT, (Object)changes.get().v1().size(), (Object)changes.get().v2().size());
            this.threadPool.generic().execute(() -> this.updateTemplates((Map)((Tuple)changes.get()).v1(), (Set)((Tuple)changes.get()).v2()));
        }
    }

    void updateTemplates(Map<String, BytesReference> changes, Set<String> deletions) {
        MasterNodeRequest request;
        for (final Map.Entry<String, BytesReference> change : changes.entrySet()) {
            request = new PutIndexTemplateRequest(change.getKey()).source(change.getValue(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes(1L));
            this.client.admin().indices().putTemplate((PutIndexTemplateRequest)request, new ActionListener<PutIndexTemplateResponse>(){

                @Override
                public void onResponse(PutIndexTemplateResponse response) {
                    if (TemplateUpgradeService.this.updatesInProgress.decrementAndGet() == 0) {
                        TemplateUpgradeService.this.logger.info("Finished upgrading templates to version {}", (Object)Version.CURRENT);
                    }
                    if (!response.isAcknowledged()) {
                        TemplateUpgradeService.this.logger.warn("Error updating template [{}], request was not acknowledged", change.getKey());
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (TemplateUpgradeService.this.updatesInProgress.decrementAndGet() == 0) {
                        TemplateUpgradeService.this.logger.info("Templates were upgraded to version {}", (Object)Version.CURRENT);
                    }
                    TemplateUpgradeService.this.logger.warn((Message)new ParameterizedMessage("Error updating template [{}]", change.getKey()), (Throwable)e);
                }
            });
        }
        for (final String template : deletions) {
            request = new DeleteIndexTemplateRequest(template);
            request.masterNodeTimeout(TimeValue.timeValueMinutes(1L));
            this.client.admin().indices().deleteTemplate((DeleteIndexTemplateRequest)request, new ActionListener<DeleteIndexTemplateResponse>(){

                @Override
                public void onResponse(DeleteIndexTemplateResponse response) {
                    TemplateUpgradeService.this.updatesInProgress.decrementAndGet();
                    if (!response.isAcknowledged()) {
                        TemplateUpgradeService.this.logger.warn("Error deleting template [{}], request was not acknowledged", (Object)template);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    TemplateUpgradeService.this.updatesInProgress.decrementAndGet();
                    if (!(e instanceof IndexTemplateMissingException)) {
                        TemplateUpgradeService.this.logger.warn((Message)new ParameterizedMessage("Error deleting template [{}]", (Object)template), (Throwable)e);
                    }
                }
            });
        }
    }

    int getUpdatesInProgress() {
        return this.updatesInProgress.get();
    }

    Optional<Tuple<Map<String, BytesReference>, Set<String>>> calculateTemplateChanges(ImmutableOpenMap<String, IndexTemplateMetaData> templates) {
        HashMap existingMap = new HashMap();
        for (ObjectObjectCursor<String, IndexTemplateMetaData> objectObjectCursor : templates) {
            existingMap.put(objectObjectCursor.key, objectObjectCursor.value);
        }
        Map upgradedMap = (Map)this.indexTemplateMetaDataUpgraders.apply(existingMap);
        if (!upgradedMap.equals(existingMap)) {
            HashSet hashSet = new HashSet();
            HashMap changes = new HashMap();
            existingMap.keySet().forEach(s -> {
                if (!upgradedMap.containsKey(s)) {
                    deletes.add(s);
                }
            });
            upgradedMap.forEach((key, value) -> {
                if (!value.equals(existingMap.get(key))) {
                    changes.put(key, this.toBytesReference((IndexTemplateMetaData)value));
                }
            });
            return Optional.of(new Tuple(changes, hashSet));
        }
        return Optional.empty();
    }

    private BytesReference toBytesReference(IndexTemplateMetaData templateMetaData) {
        try {
            return XContentHelper.toXContent((builder, params) -> {
                IndexTemplateMetaData.Builder.toInnerXContent(templateMetaData, builder, params);
                return builder;
            }, XContentType.JSON, PARAMS, false);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot serialize template [" + templateMetaData.getName() + "]", ex);
        }
    }
}

