/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TextFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.MultiValueMode;

public class ConstantIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    private final AtomicOrdinalsFieldData atomicFieldData;

    private ConstantIndexFieldData(IndexSettings indexSettings, String name, String value) {
        super(indexSettings, name, null, null, TextFieldMapper.Defaults.FIELDDATA_MIN_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MAX_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MIN_SEGMENT_SIZE);
        this.atomicFieldData = new ConstantAtomicFieldData(value);
    }

    @Override
    public void clear() {
    }

    @Override
    public final AtomicOrdinalsFieldData load(LeafReaderContext context) {
        return this.atomicFieldData;
    }

    @Override
    public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.atomicFieldData;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), source, reverse);
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return this.loadGlobal(indexReader);
    }

    private static class ConstantAtomicFieldData
    extends AbstractAtomicOrdinalsFieldData {
        private final String value;

        ConstantAtomicFieldData(String value) {
            super(DEFAULT_SCRIPT_FUNCTION);
            this.value = value;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public RandomAccessOrds getOrdinalsValues() {
            final BytesRef term = new BytesRef(this.value);
            SortedDocValues sortedValues = new SortedDocValues(){

                @Override
                public BytesRef lookupOrd(int ord) {
                    return term;
                }

                @Override
                public int getValueCount() {
                    return 1;
                }

                @Override
                public int getOrd(int docID) {
                    return 0;
                }
            };
            return DocValues.singleton(sortedValues);
        }

        @Override
        public void close() {
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final Function<MapperService, String> valueFunction;

        public Builder(Function<MapperService, String> valueFunction) {
            this.valueFunction = valueFunction;
        }

        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new ConstantIndexFieldData(indexSettings, fieldType.name(), this.valueFunction.apply(mapperService));
        }
    }
}

