/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.util.CharFilterFactory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.util.TokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.util.TokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.DocValuesFormat;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap.JarHell;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.LifecycleComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Module;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.FileSystemUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.Plugin;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.PluginInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ExecutorBuilder;

public class PluginsService
extends AbstractComponent {
    private final List<Tuple<PluginInfo, Plugin>> plugins;
    private final PluginsAndModules info;
    public static final Setting<List<String>> MANDATORY_SETTING = Setting.listSetting("plugin.mandatory", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);

    public List<Setting<?>> getPluginSettings() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettings().stream()).collect(Collectors.toList());
    }

    public List<String> getPluginSettingsFilter() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettingsFilter().stream()).collect(Collectors.toList());
    }

    public PluginsService(Settings settings, Path modulesDirectory, Path pluginsDirectory, Collection<Class<? extends Plugin>> classpathPlugins) {
        super(settings);
        ArrayList<Tuple<Object, Plugin>> pluginsLoaded = new ArrayList<Tuple<Object, Plugin>>();
        ArrayList<PluginInfo> pluginsList = new ArrayList<PluginInfo>();
        for (Class<? extends Plugin> pluginClass : classpathPlugins) {
            Plugin plugin = this.loadPlugin(pluginClass, settings);
            PluginInfo pluginInfo = new PluginInfo(pluginClass.getName(), "classpath plugin", "NA", pluginClass.getName(), false);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("plugin loaded from classpath [{}]", (Object)pluginInfo);
            }
            pluginsLoaded.add(new Tuple<Object, Plugin>(pluginInfo, plugin));
            pluginsList.add(pluginInfo);
        }
        LinkedHashSet<Bundle> seenBundles = new LinkedHashSet<Bundle>();
        ArrayList<PluginInfo> modulesList = new ArrayList<PluginInfo>();
        if (modulesDirectory != null) {
            try {
                Set<Bundle> modules = PluginsService.getModuleBundles(modulesDirectory);
                for (Bundle bundle : modules) {
                    modulesList.add(bundle.plugin);
                }
                seenBundles.addAll(modules);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize modules", ex);
            }
        }
        if (pluginsDirectory != null) {
            try {
                Set<Bundle> plugins = PluginsService.getPluginBundles(pluginsDirectory);
                for (Bundle bundle : plugins) {
                    pluginsList.add(bundle.plugin);
                }
                seenBundles.addAll(plugins);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize plugins", ex);
            }
        }
        List<Tuple<PluginInfo, Plugin>> loaded = this.loadBundles(seenBundles);
        pluginsLoaded.addAll(loaded);
        this.info = new PluginsAndModules(pluginsList, modulesList);
        this.plugins = Collections.unmodifiableList(pluginsLoaded);
        HashSet<String> pluginsNames = new HashSet<String>();
        for (Tuple<PluginInfo, Plugin> tuple : this.plugins) {
            pluginsNames.add(tuple.v1().getName());
        }
        List<String> list = MANDATORY_SETTING.get(settings);
        if (!list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String mandatoryPlugin : list) {
                if (pluginsNames.contains(mandatoryPlugin) || hashSet.contains(mandatoryPlugin)) continue;
                hashSet.add(mandatoryPlugin);
            }
            if (!hashSet.isEmpty()) {
                throw new ElasticsearchException("Missing mandatory plugins [" + Strings.collectionToDelimitedString(hashSet, ", ") + "]", new Object[0]);
            }
        }
        PluginsService.logPluginInfo(this.info.getModuleInfos(), "module", this.logger);
        PluginsService.logPluginInfo(this.info.getPluginInfos(), "plugin", this.logger);
    }

    private static void logPluginInfo(List<PluginInfo> pluginInfos, String type, Logger logger) {
        assert (pluginInfos != null);
        if (pluginInfos.isEmpty()) {
            logger.info("no " + type + "s loaded");
        } else {
            for (String name : pluginInfos.stream().map(PluginInfo::getName).sorted().collect(Collectors.toList())) {
                logger.info("loaded " + type + " [" + name + "]");
            }
        }
    }

    public Settings updatedSettings() {
        HashMap<String, String> foundSettings = new HashMap<String, String>();
        Settings.Builder builder = Settings.builder();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            Settings settings = plugin.v2().additionalSettings();
            for (String setting : settings.getAsMap().keySet()) {
                String oldPlugin = foundSettings.put(setting, plugin.v1().getName());
                if (oldPlugin == null) continue;
                throw new IllegalArgumentException("Cannot have additional setting [" + setting + "] in plugin [" + plugin.v1().getName() + "], already added in plugin [" + oldPlugin + "]");
            }
            builder.put(settings);
        }
        return builder.put(this.settings).build();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            modules.addAll(plugin.v2().createGuiceModules());
        }
        return modules;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList builders = new ArrayList();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            builders.addAll(plugin.v2().getExecutorBuilders(settings));
        }
        return builders;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            services.addAll(plugin.v2().getGuiceServiceClasses());
        }
        return services;
    }

    public void onIndexModule(IndexModule indexModule) {
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            plugin.v2().onIndexModule(indexModule);
        }
    }

    public PluginsAndModules info() {
        return this.info;
    }

    static Set<Bundle> getModuleBundles(Path modulesDirectory) throws IOException {
        if (Files.notExists(modulesDirectory, new LinkOption[0])) {
            return Collections.emptySet();
        }
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(modulesDirectory);){
            for (Path module : stream) {
                PluginInfo info = PluginInfo.readFromProperties(module);
                LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(module, "*.jar");){
                    for (Path jar : jarStream) {
                        URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                        if (urls.add(url)) continue;
                        throw new IllegalStateException("duplicate codebase: " + url);
                    }
                }
                if (bundles.add(new Bundle(info, urls))) continue;
                throw new IllegalStateException("duplicate module: " + info);
            }
        }
        return bundles;
    }

    static void checkForFailedPluginRemovals(Path pluginsDirectory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsDirectory, ".removing-*");){
            Iterator<Path> iterator = stream.iterator();
            if (iterator.hasNext()) {
                Path removing = iterator.next();
                String fileName = removing.getFileName().toString();
                String name = fileName.substring(1 + fileName.indexOf("-"));
                String message = String.format(Locale.ROOT, "found file [%s] from a failed attempt to remove the plugin [%s]; execute [elasticsearch-plugin remove %2$s]", removing, name);
                throw new IllegalStateException(message);
            }
        }
    }

    static Set<Bundle> getPluginBundles(Path pluginsDirectory) throws IOException {
        Logger logger = Loggers.getLogger(PluginsService.class);
        if (!FileSystemUtils.isAccessibleDirectory(pluginsDirectory, logger)) {
            return Collections.emptySet();
        }
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        PluginsService.checkForFailedPluginRemovals(pluginsDirectory);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsDirectory);){
            for (Path plugin : stream) {
                PluginInfo info;
                if (FileSystemUtils.isDesktopServicesStore(plugin)) continue;
                logger.trace("--- adding plugin [{}]", (Object)plugin.toAbsolutePath());
                try {
                    info = PluginInfo.readFromProperties(plugin);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not load plugin descriptor for existing plugin [" + plugin.getFileName() + "]. Was the plugin built before 2.0?", e);
                }
                LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(plugin, "*.jar");){
                    for (Path jar : jarStream) {
                        URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                        if (urls.add(url)) continue;
                        throw new IllegalStateException("duplicate codebase: " + url);
                    }
                }
                if (bundles.add(new Bundle(info, urls))) continue;
                throw new IllegalStateException("duplicate plugin: " + info);
            }
        }
        return bundles;
    }

    private List<Tuple<PluginInfo, Plugin>> loadBundles(Set<Bundle> bundles) {
        ArrayList<Tuple<PluginInfo, Plugin>> plugins = new ArrayList<Tuple<PluginInfo, Plugin>>();
        for (Bundle bundle : bundles) {
            try {
                Set<URL> classpath = JarHell.parseClassPath();
                HashSet<URL> intersection = new HashSet<URL>(classpath);
                intersection.retainAll(bundle.urls);
                if (!intersection.isEmpty()) {
                    throw new IllegalStateException("jar hell! duplicate codebases between plugin and core: " + intersection);
                }
                HashSet<URL> union = new HashSet<URL>(classpath);
                union.addAll(bundle.urls);
                JarHell.checkJarHell(union);
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to load plugin " + bundle.plugin + " due to jar hell", e);
            }
            URLClassLoader loader = URLClassLoader.newInstance(bundle.urls.toArray(new URL[0]), this.getClass().getClassLoader());
            PluginsService.reloadLuceneSPI(loader);
            Class<? extends Plugin> pluginClass = this.loadPluginClass(bundle.plugin.getClassname(), loader);
            Plugin plugin = this.loadPlugin(pluginClass, this.settings);
            plugins.add(new Tuple<PluginInfo, Plugin>(bundle.plugin, plugin));
        }
        return Collections.unmodifiableList(plugins);
    }

    static void reloadLuceneSPI(ClassLoader loader) {
        PostingsFormat.reloadPostingsFormats(loader);
        DocValuesFormat.reloadDocValuesFormats(loader);
        Codec.reloadCodecs(loader);
        CharFilterFactory.reloadCharFilters(loader);
        TokenFilterFactory.reloadTokenFilters(loader);
        TokenizerFactory.reloadTokenizers(loader);
    }

    private Class<? extends Plugin> loadPluginClass(String className, ClassLoader loader) {
        try {
            return loader.loadClass(className).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new ElasticsearchException("Could not find plugin class [" + className + "]", (Throwable)e, new Object[0]);
        }
    }

    private Plugin loadPlugin(Class<? extends Plugin> pluginClass, Settings settings) {
        try {
            try {
                return pluginClass.getConstructor(Settings.class).newInstance(settings);
            }
            catch (NoSuchMethodException e) {
                try {
                    return pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw new ElasticsearchException("No constructor for [" + pluginClass + "]. A plugin class must have either an empty default constructor or a single argument constructor accepting a Settings instance", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to load plugin class [" + pluginClass.getName() + "]", (Throwable)e, new Object[0]);
        }
    }

    public <T> List<T> filterPlugins(Class<T> type) {
        return this.plugins.stream().filter(x -> type.isAssignableFrom(((Plugin)x.v2()).getClass())).map(p -> p.v2()).collect(Collectors.toList());
    }

    static class Bundle {
        final PluginInfo plugin;
        final Set<URL> urls;

        Bundle(PluginInfo plugin, Set<URL> urls) {
            this.plugin = Objects.requireNonNull(plugin);
            this.urls = Objects.requireNonNull(urls);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bundle bundle = (Bundle)o;
            return Objects.equals(this.plugin, bundle.plugin);
        }

        public int hashCode() {
            return Objects.hash(this.plugin);
        }
    }
}

