/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestBuilderListener;

public class RestClearIndicesCacheAction
extends BaseRestHandler {
    public RestClearIndicesCacheAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_cache/clear", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        ClearIndicesCacheRequest clearIndicesCacheRequest = new ClearIndicesCacheRequest(Strings.splitStringByCommaToArray(request.param("index")));
        clearIndicesCacheRequest.indicesOptions(IndicesOptions.fromRequest(request, clearIndicesCacheRequest.indicesOptions()));
        RestClearIndicesCacheAction.fromRequest(request, clearIndicesCacheRequest);
        return channel -> client.admin().indices().clearCache(clearIndicesCacheRequest, (ActionListener<ClearIndicesCacheResponse>)new RestBuilderListener<ClearIndicesCacheResponse>(channel){

            @Override
            public RestResponse buildResponse(ClearIndicesCacheResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, request, response);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    public static ClearIndicesCacheRequest fromRequest(RestRequest request, ClearIndicesCacheRequest clearIndicesCacheRequest) {
        for (Map.Entry<String, String> entry : request.params().entrySet()) {
            if (Fields.QUERY.match(entry.getKey())) {
                clearIndicesCacheRequest.queryCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.queryCache()));
            }
            if (Fields.REQUEST.match(entry.getKey())) {
                clearIndicesCacheRequest.requestCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.requestCache()));
            }
            if (Fields.FIELD_DATA.match(entry.getKey())) {
                clearIndicesCacheRequest.fieldDataCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.fieldDataCache()));
            }
            if (Fields.RECYCLER.match(entry.getKey())) {
                clearIndicesCacheRequest.recycler(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.recycler()));
            }
            if (!Fields.FIELDS.match(entry.getKey())) continue;
            clearIndicesCacheRequest.fields(request.paramAsStringArray(entry.getKey(), clearIndicesCacheRequest.fields()));
        }
        return clearIndicesCacheRequest;
    }

    public static class Fields {
        public static final ParseField QUERY = new ParseField("query", "filter", "filter_cache");
        public static final ParseField REQUEST = new ParseField("request", "request_cache");
        public static final ParseField FIELD_DATA = new ParseField("field_data", "fielddata");
        public static final ParseField RECYCLER = new ParseField("recycler", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
    }
}

