/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestIndexDeleteAliasesAction
extends BaseRestHandler {
    public RestIndexDeleteAliasesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_aliases/{name}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] aliases = Strings.splitStringByCommaToArray(request.param("name"));
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
        indicesAliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.remove().indices(indices).aliases(aliases));
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        return channel -> client.admin().indices().aliases(indicesAliasesRequest, new AcknowledgedRestListener<IndicesAliasesResponse>((RestChannel)channel));
    }
}

