/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.ArrayUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.ObjectArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public abstract class AbstractTDigestPercentilesAggregator
extends NumericMetricsAggregator.MultiValue {
    protected final double[] keys;
    protected final ValuesSource.Numeric valuesSource;
    protected final DocValueFormat formatter;
    protected ObjectArray<TDigestState> states;
    protected final double compression;
    protected final boolean keyed;

    private static int indexOfKey(double[] keys, double key) {
        return ArrayUtils.binarySearch(keys, key, 0.001);
    }

    public AbstractTDigestPercentilesAggregator(String name, ValuesSource.Numeric valuesSource, SearchContext context, Aggregator parent, double[] keys, double compression, boolean keyed, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.keyed = keyed;
        this.formatter = formatter;
        this.states = context.bigArrays().newObjectArray(1L);
        this.keys = keys;
        this.compression = compression;
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                AbstractTDigestPercentilesAggregator.this.states = bigArrays.grow(AbstractTDigestPercentilesAggregator.this.states, bucket + 1L);
                TDigestState state = AbstractTDigestPercentilesAggregator.this.states.get(bucket);
                if (state == null) {
                    state = new TDigestState(AbstractTDigestPercentilesAggregator.this.compression);
                    AbstractTDigestPercentilesAggregator.this.states.set(bucket, state);
                }
                values.setDocument(doc);
                int valueCount = values.count();
                for (int i = 0; i < valueCount; ++i) {
                    state.add(values.valueAt(i));
                }
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        return AbstractTDigestPercentilesAggregator.indexOfKey(this.keys, Double.parseDouble(name)) >= 0;
    }

    protected TDigestState getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        TDigestState state = this.states.get(bucketOrd);
        return state;
    }

    @Override
    protected void doClose() {
        Releasables.close(this.states);
    }
}

