/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHits;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchPhaseResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchShardTarget;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.query.QuerySearchResult;

public final class FetchSearchResult
extends SearchPhaseResult {
    private SearchHits hits;
    private transient int counter;

    public FetchSearchResult() {
    }

    public FetchSearchResult(long id, SearchShardTarget shardTarget) {
        this.requestId = id;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public QuerySearchResult queryResult() {
        return null;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this;
    }

    public void hits(SearchHits hits) {
        assert (this.assertNoSearchTarget(hits));
        this.hits = hits;
    }

    private boolean assertNoSearchTarget(SearchHits hits) {
        for (SearchHit hit : hits.hits()) {
            assert (hit.getShard() == null) : "expected null but got: " + hit.getShard();
        }
        return true;
    }

    public SearchHits hits() {
        return this.hits;
    }

    public FetchSearchResult initCounter() {
        this.counter = 0;
        return this;
    }

    public int counterGetAndIncrement() {
        return this.counter++;
    }

    public static FetchSearchResult readFetchSearchResult(StreamInput in) throws IOException {
        FetchSearchResult result = new FetchSearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.requestId = in.readLong();
        this.hits = SearchHits.readSearchHits(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.requestId);
        this.hits.writeTo(out);
    }
}

