/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.slice;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.RandomAccessWeight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.slice.SliceQuery;

public final class DocValuesSliceQuery
extends SliceQuery {
    public DocValuesSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesSliceQuery.this.getField());
                return new Bits(){

                    @Override
                    public boolean get(int doc) {
                        values.setDocument(doc);
                        int i = 0;
                        if (i < values.count()) {
                            return DocValuesSliceQuery.this.contains(BitMixer.mix(values.valueAt(i)));
                        }
                        return DocValuesSliceQuery.this.contains(0L);
                    }

                    @Override
                    public int length() {
                        return context.reader().maxDoc();
                    }
                };
            }
        };
    }
}

