/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.com.tdunning.math.stats;

import java.nio.LongBuffer;

public class Simple64 {
    private static final int NUM_DATA_BITS = 60;
    private static final int BITS_30_MASK = 0x3FFFFFFF;
    private static final int BITS_20_MASK = 1048575;
    private static final int BITS_15_MASK = Short.MAX_VALUE;
    private static final int BITS_12_MASK = 4095;
    private static final int BITS_11_MASK = 2047;
    private static final int BITS_10_MASK = 1023;
    private static final int BITS_8_MASK = 255;
    private static final int BITS_7_MASK = 127;
    private static final int BITS_6_MASK = 63;
    private static final int BITS_5_MASK = 31;
    private static final int BITS_4_MASK = 15;
    private static final int BITS_3_MASK = 7;
    private static final int BITS_2_MASK = 3;
    private static final int BITS_1_MASK = 1;
    private static final int STATUS_1NUM_60BITS = 14;
    private static final int STATUS_2NUM_30BITS = 13;
    private static final int STATUS_3NUM_20BITS = 12;
    private static final int STATUS_4NUM_15BITS = 11;
    private static final int STATUS_5NUM_12BITS = 10;
    private static final int STATUS_6NUM_10BITS = 9;
    private static final int STATUS_7NUM_8BITS = 8;
    private static final int STATUS_8NUM_7BITS = 7;
    private static final int STATUS_10NUM_6BITS = 6;
    private static final int STATUS_12NUM_5BITS = 5;
    private static final int STATUS_15NUM_4BITS = 4;
    private static final int STATUS_20NUM_3BITS = 3;
    private static final int STATUS_30NUM_2BITS = 2;
    private static final int STATUS_60NUM_1BITS = 1;
    private int inputCompressable = 1;
    private int minBits = 1;
    private long maxFitPlus1 = 1 << this.minBits;
    private final long[] pending = new long[100];
    private int inputCount;

    private void reset() {
        this.inputCompressable = 1;
        this.minBits = 1;
        this.inputCount = 0;
        this.maxFitPlus1 = 1 << this.minBits;
    }

    public int add(long v, long[] out) {
        this.pending[this.inputCount++] = v;
        while (this.inputCompressable <= this.inputCount) {
            int consumed;
            long s9;
            long nextData = this.pending[this.inputCompressable - 1];
            while (!(nextData < this.maxFitPlus1 || this.minBits >= 60 || this.minBits == 7 && this.inputCompressable == 8 && nextData < this.maxFitPlus1 << 4 || this.minBits == 8 && this.inputCompressable == 7 && nextData < this.maxFitPlus1 << 4)) {
                ++this.minBits;
                this.maxFitPlus1 <<= 1;
                if (this.inputCompressable * this.minBits <= 60) continue;
                --this.inputCompressable;
                break;
            }
            ++this.inputCompressable;
            if (this.inputCompressable * this.minBits <= 60) continue;
            --this.inputCompressable;
            assert (this.inputCompressable > 0);
            while (this.inputCompressable * (this.minBits + 1) <= 60) {
                ++this.minBits;
            }
            switch (this.minBits) {
                case 60: {
                    s9 = 14L;
                    s9 |= this.pending[0] << 4;
                    consumed = 1;
                    break;
                }
                case 30: {
                    s9 = 13L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 34;
                    consumed = 2;
                    break;
                }
                case 20: {
                    s9 = 12L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 24;
                    s9 |= this.pending[2] << 44;
                    consumed = 3;
                    break;
                }
                case 15: {
                    s9 = 11L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 19;
                    s9 |= this.pending[2] << 34;
                    s9 |= this.pending[3] << 49;
                    consumed = 4;
                    break;
                }
                case 12: {
                    s9 = 10L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 16;
                    s9 |= this.pending[2] << 28;
                    s9 |= this.pending[3] << 40;
                    s9 |= this.pending[4] << 52;
                    consumed = 5;
                    break;
                }
                case 10: {
                    s9 = 9L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 14;
                    s9 |= this.pending[2] << 24;
                    s9 |= this.pending[3] << 34;
                    s9 |= this.pending[4] << 44;
                    s9 |= this.pending[5] << 54;
                    consumed = 6;
                    break;
                }
                case 8: {
                    s9 = 8L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 12;
                    s9 |= this.pending[2] << 20;
                    s9 |= this.pending[3] << 28;
                    s9 |= this.pending[4] << 36;
                    s9 |= this.pending[5] << 44;
                    s9 |= this.pending[6] << 52;
                    consumed = 7;
                    break;
                }
                case 7: {
                    s9 = 7L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 11;
                    s9 |= this.pending[2] << 18;
                    s9 |= this.pending[3] << 25;
                    s9 |= this.pending[4] << 32;
                    s9 |= this.pending[5] << 39;
                    s9 |= this.pending[6] << 46;
                    s9 |= this.pending[7] << 53;
                    consumed = 8;
                    break;
                }
                case 6: {
                    s9 = 6L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 10;
                    s9 |= this.pending[2] << 16;
                    s9 |= this.pending[3] << 22;
                    s9 |= this.pending[4] << 28;
                    s9 |= this.pending[5] << 34;
                    s9 |= this.pending[6] << 40;
                    s9 |= this.pending[7] << 46;
                    s9 |= this.pending[8] << 52;
                    s9 |= this.pending[9] << 58;
                    consumed = 10;
                    break;
                }
                case 5: {
                    s9 = 5L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 9;
                    s9 |= this.pending[2] << 14;
                    s9 |= this.pending[3] << 19;
                    s9 |= this.pending[4] << 24;
                    s9 |= this.pending[5] << 29;
                    s9 |= this.pending[6] << 34;
                    s9 |= this.pending[7] << 39;
                    s9 |= this.pending[8] << 44;
                    s9 |= this.pending[9] << 49;
                    s9 |= this.pending[10] << 54;
                    s9 |= this.pending[11] << 59;
                    consumed = 12;
                    break;
                }
                case 4: {
                    s9 = 4L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 8;
                    s9 |= this.pending[2] << 12;
                    s9 |= this.pending[3] << 16;
                    s9 |= this.pending[4] << 20;
                    s9 |= this.pending[5] << 24;
                    s9 |= this.pending[6] << 28;
                    s9 |= this.pending[7] << 32;
                    s9 |= this.pending[8] << 36;
                    s9 |= this.pending[9] << 40;
                    s9 |= this.pending[10] << 44;
                    s9 |= this.pending[11] << 48;
                    s9 |= this.pending[12] << 52;
                    s9 |= this.pending[13] << 56;
                    s9 |= this.pending[14] << 60;
                    consumed = 15;
                    break;
                }
                case 3: {
                    s9 = 3L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 7;
                    s9 |= this.pending[2] << 10;
                    s9 |= this.pending[3] << 13;
                    s9 |= this.pending[4] << 16;
                    s9 |= this.pending[5] << 19;
                    s9 |= this.pending[6] << 22;
                    s9 |= this.pending[7] << 25;
                    s9 |= this.pending[8] << 28;
                    s9 |= this.pending[9] << 31;
                    s9 |= this.pending[10] << 34;
                    s9 |= this.pending[11] << 37;
                    s9 |= this.pending[12] << 40;
                    s9 |= this.pending[13] << 43;
                    s9 |= this.pending[14] << 46;
                    s9 |= this.pending[15] << 49;
                    s9 |= this.pending[16] << 52;
                    s9 |= this.pending[17] << 55;
                    s9 |= this.pending[18] << 58;
                    s9 |= this.pending[19] << 61;
                    consumed = 20;
                    break;
                }
                case 2: {
                    s9 = 2L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 6;
                    s9 |= this.pending[2] << 8;
                    s9 |= this.pending[3] << 10;
                    s9 |= this.pending[4] << 12;
                    s9 |= this.pending[5] << 14;
                    s9 |= this.pending[6] << 16;
                    s9 |= this.pending[7] << 18;
                    s9 |= this.pending[8] << 20;
                    s9 |= this.pending[9] << 22;
                    s9 |= this.pending[10] << 24;
                    s9 |= this.pending[11] << 26;
                    s9 |= this.pending[12] << 28;
                    s9 |= this.pending[13] << 30;
                    s9 |= this.pending[14] << 32;
                    s9 |= this.pending[15] << 34;
                    s9 |= this.pending[16] << 36;
                    s9 |= this.pending[17] << 38;
                    s9 |= this.pending[18] << 40;
                    s9 |= this.pending[19] << 42;
                    s9 |= this.pending[20] << 44;
                    s9 |= this.pending[21] << 46;
                    s9 |= this.pending[22] << 48;
                    s9 |= this.pending[23] << 50;
                    s9 |= this.pending[24] << 52;
                    s9 |= this.pending[25] << 54;
                    s9 |= this.pending[26] << 56;
                    s9 |= this.pending[27] << 58;
                    s9 |= this.pending[28] << 60;
                    s9 |= this.pending[29] << 62;
                    consumed = 30;
                    break;
                }
                case 1: {
                    s9 = 1L;
                    s9 |= this.pending[0] << 4;
                    s9 |= this.pending[1] << 5;
                    s9 |= this.pending[2] << 6;
                    s9 |= this.pending[3] << 7;
                    s9 |= this.pending[4] << 8;
                    s9 |= this.pending[5] << 9;
                    s9 |= this.pending[6] << 10;
                    s9 |= this.pending[7] << 11;
                    s9 |= this.pending[8] << 12;
                    s9 |= this.pending[9] << 13;
                    s9 |= this.pending[10] << 14;
                    s9 |= this.pending[11] << 15;
                    s9 |= this.pending[12] << 16;
                    s9 |= this.pending[13] << 17;
                    s9 |= this.pending[14] << 18;
                    s9 |= this.pending[15] << 19;
                    s9 |= this.pending[16] << 20;
                    s9 |= this.pending[17] << 21;
                    s9 |= this.pending[18] << 22;
                    s9 |= this.pending[19] << 23;
                    s9 |= this.pending[20] << 24;
                    s9 |= this.pending[21] << 25;
                    s9 |= this.pending[22] << 26;
                    s9 |= this.pending[23] << 27;
                    s9 |= this.pending[24] << 28;
                    s9 |= this.pending[25] << 29;
                    s9 |= this.pending[26] << 30;
                    s9 |= this.pending[27] << 31;
                    s9 |= this.pending[28] << 32;
                    s9 |= this.pending[29] << 33;
                    s9 |= this.pending[30] << 34;
                    s9 |= this.pending[31] << 35;
                    s9 |= this.pending[32] << 36;
                    s9 |= this.pending[33] << 37;
                    s9 |= this.pending[34] << 38;
                    s9 |= this.pending[35] << 39;
                    s9 |= this.pending[36] << 40;
                    s9 |= this.pending[37] << 41;
                    s9 |= this.pending[38] << 42;
                    s9 |= this.pending[39] << 43;
                    s9 |= this.pending[40] << 44;
                    s9 |= this.pending[41] << 45;
                    s9 |= this.pending[42] << 46;
                    s9 |= this.pending[43] << 47;
                    s9 |= this.pending[44] << 48;
                    s9 |= this.pending[45] << 49;
                    s9 |= this.pending[46] << 50;
                    s9 |= this.pending[47] << 51;
                    s9 |= this.pending[48] << 52;
                    s9 |= this.pending[49] << 53;
                    s9 |= this.pending[50] << 54;
                    s9 |= this.pending[51] << 55;
                    s9 |= this.pending[52] << 56;
                    s9 |= this.pending[53] << 57;
                    s9 |= this.pending[54] << 58;
                    s9 |= this.pending[55] << 59;
                    s9 |= this.pending[56] << 60;
                    s9 |= this.pending[57] << 61;
                    s9 |= this.pending[58] << 62;
                    s9 |= this.pending[59] << 63;
                    consumed = 60;
                    break;
                }
                default: {
                    assert (false);
                    s9 = 0L;
                    consumed = 60;
                }
            }
            int leftover = this.inputCount - consumed;
            assert (leftover >= 0) : "consumed=" + consumed + " vs " + this.inputCompressable;
            this.reset();
            System.arraycopy(this.pending, consumed, this.pending, 0, leftover);
            this.inputCount = leftover;
            out[0] = s9;
            return consumed;
        }
        return 0;
    }

    private static int compressSingle(long[] uncompressed, int inOffset, int inSize, LongBuffer compressedBuffer) {
        long nextData;
        if (inSize < 1) {
            throw new IllegalArgumentException("Cannot compress input with non positive size " + inSize);
        }
        int inputCompressable = 1;
        int minBits = 1;
        long maxFitPlus1 = 1 << minBits;
        block16: do {
            if ((nextData = uncompressed[inOffset + inputCompressable - 1]) < 0L) {
                throw new IllegalArgumentException("Cannot compress negative input " + nextData + " (at index " + (inOffset + inputCompressable - 1) + ")");
            }
            while (!(nextData < maxFitPlus1 || minBits >= 60 || minBits == 7 && inputCompressable == 8 && nextData < maxFitPlus1 << 4 || minBits == 8 && inputCompressable == 7 && nextData < maxFitPlus1 << 4)) {
                maxFitPlus1 <<= 1;
                if (inputCompressable * ++minBits <= 60) continue;
                --inputCompressable;
                continue block16;
            }
        } while (++inputCompressable * minBits <= 60 && inputCompressable <= inSize);
        if (--inputCompressable == 0) {
            throw new IllegalArgumentException("Cannot compress input " + nextData + " with more than " + 60 + " bits (at offSet " + inOffset + ")");
        }
        while (inputCompressable * (minBits + 1) <= 60) {
            ++minBits;
        }
        if ((inputCompressable + 1) * minBits <= 60) {
            ++minBits;
        }
        switch (minBits) {
            case 60: {
                long s9 = 14L;
                compressedBuffer.put(s9 |= uncompressed[inOffset] << 4);
                return 1;
            }
            case 30: {
                long s9 = 13L;
                s9 |= uncompressed[inOffset] << 4;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 1] << 34);
                return 2;
            }
            case 20: {
                long s9 = 12L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 24;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 2] << 44);
                return 3;
            }
            case 15: {
                long s9 = 11L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 19;
                s9 |= uncompressed[inOffset + 2] << 34;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 3] << 49);
                return 4;
            }
            case 12: {
                long s9 = 10L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 16;
                s9 |= uncompressed[inOffset + 2] << 28;
                s9 |= uncompressed[inOffset + 3] << 40;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 4] << 52);
                return 5;
            }
            case 10: {
                long s9 = 9L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 14;
                s9 |= uncompressed[inOffset + 2] << 24;
                s9 |= uncompressed[inOffset + 3] << 34;
                s9 |= uncompressed[inOffset + 4] << 44;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 5] << 54);
                return 6;
            }
            case 8: {
                long s9 = 8L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 12;
                s9 |= uncompressed[inOffset + 2] << 20;
                s9 |= uncompressed[inOffset + 3] << 28;
                s9 |= uncompressed[inOffset + 4] << 36;
                s9 |= uncompressed[inOffset + 5] << 44;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 6] << 52);
                return 7;
            }
            case 7: {
                long s9 = 7L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 11;
                s9 |= uncompressed[inOffset + 2] << 18;
                s9 |= uncompressed[inOffset + 3] << 25;
                s9 |= uncompressed[inOffset + 4] << 32;
                s9 |= uncompressed[inOffset + 5] << 39;
                s9 |= uncompressed[inOffset + 6] << 46;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 7] << 53);
                return 8;
            }
            case 6: {
                long s9 = 6L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 10;
                s9 |= uncompressed[inOffset + 2] << 16;
                s9 |= uncompressed[inOffset + 3] << 22;
                s9 |= uncompressed[inOffset + 4] << 28;
                s9 |= uncompressed[inOffset + 5] << 34;
                s9 |= uncompressed[inOffset + 6] << 40;
                s9 |= uncompressed[inOffset + 7] << 46;
                s9 |= uncompressed[inOffset + 8] << 52;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 9] << 58);
                return 10;
            }
            case 5: {
                long s9 = 5L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 9;
                s9 |= uncompressed[inOffset + 2] << 14;
                s9 |= uncompressed[inOffset + 3] << 19;
                s9 |= uncompressed[inOffset + 4] << 24;
                s9 |= uncompressed[inOffset + 5] << 29;
                s9 |= uncompressed[inOffset + 6] << 34;
                s9 |= uncompressed[inOffset + 7] << 39;
                s9 |= uncompressed[inOffset + 8] << 44;
                s9 |= uncompressed[inOffset + 9] << 49;
                s9 |= uncompressed[inOffset + 10] << 54;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 11] << 59);
                return 12;
            }
            case 4: {
                long s9 = 4L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 8;
                s9 |= uncompressed[inOffset + 2] << 12;
                s9 |= uncompressed[inOffset + 3] << 16;
                s9 |= uncompressed[inOffset + 4] << 20;
                s9 |= uncompressed[inOffset + 5] << 24;
                s9 |= uncompressed[inOffset + 6] << 28;
                s9 |= uncompressed[inOffset + 7] << 32;
                s9 |= uncompressed[inOffset + 8] << 36;
                s9 |= uncompressed[inOffset + 9] << 40;
                s9 |= uncompressed[inOffset + 10] << 44;
                s9 |= uncompressed[inOffset + 11] << 48;
                s9 |= uncompressed[inOffset + 12] << 52;
                s9 |= uncompressed[inOffset + 13] << 56;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 14] << 60);
                return 15;
            }
            case 3: {
                long s9 = 3L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 7;
                s9 |= uncompressed[inOffset + 2] << 10;
                s9 |= uncompressed[inOffset + 3] << 13;
                s9 |= uncompressed[inOffset + 4] << 16;
                s9 |= uncompressed[inOffset + 5] << 19;
                s9 |= uncompressed[inOffset + 6] << 22;
                s9 |= uncompressed[inOffset + 7] << 25;
                s9 |= uncompressed[inOffset + 8] << 28;
                s9 |= uncompressed[inOffset + 9] << 31;
                s9 |= uncompressed[inOffset + 10] << 34;
                s9 |= uncompressed[inOffset + 11] << 37;
                s9 |= uncompressed[inOffset + 12] << 40;
                s9 |= uncompressed[inOffset + 13] << 43;
                s9 |= uncompressed[inOffset + 14] << 46;
                s9 |= uncompressed[inOffset + 15] << 49;
                s9 |= uncompressed[inOffset + 16] << 52;
                s9 |= uncompressed[inOffset + 17] << 55;
                s9 |= uncompressed[inOffset + 18] << 58;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 19] << 61);
                return 20;
            }
            case 2: {
                long s9 = 2L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 6;
                s9 |= uncompressed[inOffset + 2] << 8;
                s9 |= uncompressed[inOffset + 3] << 10;
                s9 |= uncompressed[inOffset + 4] << 12;
                s9 |= uncompressed[inOffset + 5] << 14;
                s9 |= uncompressed[inOffset + 6] << 16;
                s9 |= uncompressed[inOffset + 7] << 18;
                s9 |= uncompressed[inOffset + 8] << 20;
                s9 |= uncompressed[inOffset + 9] << 22;
                s9 |= uncompressed[inOffset + 10] << 24;
                s9 |= uncompressed[inOffset + 11] << 26;
                s9 |= uncompressed[inOffset + 12] << 28;
                s9 |= uncompressed[inOffset + 13] << 30;
                s9 |= uncompressed[inOffset + 14] << 32;
                s9 |= uncompressed[inOffset + 15] << 34;
                s9 |= uncompressed[inOffset + 16] << 36;
                s9 |= uncompressed[inOffset + 17] << 38;
                s9 |= uncompressed[inOffset + 18] << 40;
                s9 |= uncompressed[inOffset + 19] << 42;
                s9 |= uncompressed[inOffset + 20] << 44;
                s9 |= uncompressed[inOffset + 21] << 46;
                s9 |= uncompressed[inOffset + 22] << 48;
                s9 |= uncompressed[inOffset + 23] << 50;
                s9 |= uncompressed[inOffset + 24] << 52;
                s9 |= uncompressed[inOffset + 25] << 54;
                s9 |= uncompressed[inOffset + 26] << 56;
                s9 |= uncompressed[inOffset + 27] << 58;
                s9 |= uncompressed[inOffset + 28] << 60;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 29] << 62);
                return 30;
            }
            case 1: {
                long s9 = 1L;
                s9 |= uncompressed[inOffset] << 4;
                s9 |= uncompressed[inOffset + 1] << 5;
                s9 |= uncompressed[inOffset + 2] << 6;
                s9 |= uncompressed[inOffset + 3] << 7;
                s9 |= uncompressed[inOffset + 4] << 8;
                s9 |= uncompressed[inOffset + 5] << 9;
                s9 |= uncompressed[inOffset + 6] << 10;
                s9 |= uncompressed[inOffset + 7] << 11;
                s9 |= uncompressed[inOffset + 8] << 12;
                s9 |= uncompressed[inOffset + 9] << 13;
                s9 |= uncompressed[inOffset + 10] << 14;
                s9 |= uncompressed[inOffset + 11] << 15;
                s9 |= uncompressed[inOffset + 12] << 16;
                s9 |= uncompressed[inOffset + 13] << 17;
                s9 |= uncompressed[inOffset + 14] << 18;
                s9 |= uncompressed[inOffset + 15] << 19;
                s9 |= uncompressed[inOffset + 16] << 20;
                s9 |= uncompressed[inOffset + 17] << 21;
                s9 |= uncompressed[inOffset + 18] << 22;
                s9 |= uncompressed[inOffset + 19] << 23;
                s9 |= uncompressed[inOffset + 20] << 24;
                s9 |= uncompressed[inOffset + 21] << 25;
                s9 |= uncompressed[inOffset + 22] << 26;
                s9 |= uncompressed[inOffset + 23] << 27;
                s9 |= uncompressed[inOffset + 24] << 28;
                s9 |= uncompressed[inOffset + 25] << 29;
                s9 |= uncompressed[inOffset + 26] << 30;
                s9 |= uncompressed[inOffset + 27] << 31;
                s9 |= uncompressed[inOffset + 28] << 32;
                s9 |= uncompressed[inOffset + 29] << 33;
                s9 |= uncompressed[inOffset + 30] << 34;
                s9 |= uncompressed[inOffset + 31] << 35;
                s9 |= uncompressed[inOffset + 32] << 36;
                s9 |= uncompressed[inOffset + 33] << 37;
                s9 |= uncompressed[inOffset + 34] << 38;
                s9 |= uncompressed[inOffset + 35] << 39;
                s9 |= uncompressed[inOffset + 36] << 40;
                s9 |= uncompressed[inOffset + 37] << 41;
                s9 |= uncompressed[inOffset + 38] << 42;
                s9 |= uncompressed[inOffset + 39] << 43;
                s9 |= uncompressed[inOffset + 40] << 44;
                s9 |= uncompressed[inOffset + 41] << 45;
                s9 |= uncompressed[inOffset + 42] << 46;
                s9 |= uncompressed[inOffset + 43] << 47;
                s9 |= uncompressed[inOffset + 44] << 48;
                s9 |= uncompressed[inOffset + 45] << 49;
                s9 |= uncompressed[inOffset + 46] << 50;
                s9 |= uncompressed[inOffset + 47] << 51;
                s9 |= uncompressed[inOffset + 48] << 52;
                s9 |= uncompressed[inOffset + 49] << 53;
                s9 |= uncompressed[inOffset + 50] << 54;
                s9 |= uncompressed[inOffset + 51] << 55;
                s9 |= uncompressed[inOffset + 52] << 56;
                s9 |= uncompressed[inOffset + 53] << 57;
                s9 |= uncompressed[inOffset + 54] << 58;
                s9 |= uncompressed[inOffset + 55] << 59;
                s9 |= uncompressed[inOffset + 56] << 60;
                s9 |= uncompressed[inOffset + 57] << 61;
                s9 |= uncompressed[inOffset + 58] << 62;
                compressedBuffer.put(s9 |= uncompressed[inOffset + 59] << 63);
                return 60;
            }
        }
        throw new Error("S98b.compressSingle internal error: unknown minBits: " + minBits);
    }

    private static int decompressSingle(long s9, long[] decompressed, int outOffset) {
        switch ((int)(s9 & 0xFL)) {
            case 14: {
                decompressed[outOffset] = s9 >>> 4;
                return 1;
            }
            case 13: {
                decompressed[outOffset] = s9 >>> 4 & 0x3FFFFFFFL;
                decompressed[outOffset + 1] = s9 >>> 34 & 0x3FFFFFFFL;
                return 2;
            }
            case 12: {
                decompressed[outOffset] = s9 >>> 4 & 0xFFFFFL;
                decompressed[outOffset + 1] = s9 >>> 24 & 0xFFFFFL;
                decompressed[outOffset + 2] = s9 >>> 44 & 0xFFFFFL;
                return 3;
            }
            case 11: {
                decompressed[outOffset] = s9 >>> 4 & 0x7FFFL;
                decompressed[outOffset + 1] = s9 >>> 19 & 0x7FFFL;
                decompressed[outOffset + 2] = s9 >>> 34 & 0x7FFFL;
                decompressed[outOffset + 3] = s9 >>> 49 & 0x7FFFL;
                return 4;
            }
            case 10: {
                decompressed[outOffset] = s9 >>> 4 & 0xFFFL;
                decompressed[outOffset + 1] = s9 >>> 16 & 0xFFFL;
                decompressed[outOffset + 2] = s9 >>> 28 & 0xFFFL;
                decompressed[outOffset + 3] = s9 >>> 40 & 0xFFFL;
                decompressed[outOffset + 4] = s9 >>> 52 & 0xFFFL;
                return 5;
            }
            case 9: {
                decompressed[outOffset] = s9 >>> 4 & 0x3FFL;
                decompressed[outOffset + 1] = s9 >>> 14 & 0x3FFL;
                decompressed[outOffset + 2] = s9 >>> 24 & 0x3FFL;
                decompressed[outOffset + 3] = s9 >>> 34 & 0x3FFL;
                decompressed[outOffset + 4] = s9 >>> 44 & 0x3FFL;
                decompressed[outOffset + 5] = s9 >>> 54 & 0x3FFL;
                return 6;
            }
            case 8: {
                decompressed[outOffset] = s9 >>> 4 & 0xFFL;
                decompressed[outOffset + 1] = s9 >>> 12 & 0xFFL;
                decompressed[outOffset + 2] = s9 >>> 20 & 0xFFL;
                decompressed[outOffset + 3] = s9 >>> 28 & 0xFFL;
                decompressed[outOffset + 4] = s9 >>> 36 & 0xFFL;
                decompressed[outOffset + 5] = s9 >>> 44 & 0xFFL;
                decompressed[outOffset + 6] = s9 >>> 52 & 0xFFFL;
                return 7;
            }
            case 7: {
                decompressed[outOffset] = s9 >>> 4 & 0x7FL;
                decompressed[outOffset + 1] = s9 >>> 11 & 0x7FL;
                decompressed[outOffset + 2] = s9 >>> 18 & 0x7FL;
                decompressed[outOffset + 3] = s9 >>> 25 & 0x7FL;
                decompressed[outOffset + 4] = s9 >>> 32 & 0x7FL;
                decompressed[outOffset + 5] = s9 >>> 39 & 0x7FL;
                decompressed[outOffset + 6] = s9 >>> 46 & 0x7FL;
                decompressed[outOffset + 7] = s9 >>> 53 & 0x7FFL;
                return 8;
            }
            case 6: {
                decompressed[outOffset] = s9 >>> 4 & 0x3FL;
                decompressed[outOffset + 1] = s9 >>> 10 & 0x3FL;
                decompressed[outOffset + 2] = s9 >>> 16 & 0x3FL;
                decompressed[outOffset + 3] = s9 >>> 22 & 0x3FL;
                decompressed[outOffset + 4] = s9 >>> 28 & 0x3FL;
                decompressed[outOffset + 5] = s9 >>> 34 & 0x3FL;
                decompressed[outOffset + 6] = s9 >>> 40 & 0x3FL;
                decompressed[outOffset + 7] = s9 >>> 46 & 0x3FL;
                decompressed[outOffset + 8] = s9 >>> 52 & 0x3FL;
                decompressed[outOffset + 9] = s9 >>> 58 & 0x3FL;
                return 10;
            }
            case 5: {
                decompressed[outOffset] = s9 >>> 4 & 0x1FL;
                decompressed[outOffset + 1] = s9 >>> 9 & 0x1FL;
                decompressed[outOffset + 2] = s9 >>> 14 & 0x1FL;
                decompressed[outOffset + 3] = s9 >>> 19 & 0x1FL;
                decompressed[outOffset + 4] = s9 >>> 24 & 0x1FL;
                decompressed[outOffset + 5] = s9 >>> 29 & 0x1FL;
                decompressed[outOffset + 6] = s9 >>> 34 & 0x1FL;
                decompressed[outOffset + 7] = s9 >>> 39 & 0x1FL;
                decompressed[outOffset + 8] = s9 >>> 44 & 0x1FL;
                decompressed[outOffset + 9] = s9 >>> 49 & 0x1FL;
                decompressed[outOffset + 10] = s9 >>> 54 & 0x1FL;
                decompressed[outOffset + 11] = s9 >>> 59 & 0x1FL;
                return 12;
            }
            case 4: {
                decompressed[outOffset] = s9 >>> 4 & 0xFL;
                decompressed[outOffset + 1] = s9 >>> 8 & 0xFL;
                decompressed[outOffset + 2] = s9 >>> 12 & 0xFL;
                decompressed[outOffset + 3] = s9 >>> 16 & 0xFL;
                decompressed[outOffset + 4] = s9 >>> 20 & 0xFL;
                decompressed[outOffset + 5] = s9 >>> 24 & 0xFL;
                decompressed[outOffset + 6] = s9 >>> 28 & 0xFL;
                decompressed[outOffset + 6] = s9 >>> 32 & 0xFL;
                decompressed[outOffset + 8] = s9 >>> 36 & 0xFL;
                decompressed[outOffset + 9] = s9 >>> 40 & 0xFL;
                decompressed[outOffset + 10] = s9 >>> 44 & 0xFL;
                decompressed[outOffset + 11] = s9 >>> 48 & 0xFL;
                decompressed[outOffset + 12] = s9 >>> 52 & 0xFL;
                decompressed[outOffset + 13] = s9 >>> 56 & 0xFL;
                decompressed[outOffset + 14] = s9 >>> 60 & 0xFL;
                return 15;
            }
            case 3: {
                decompressed[outOffset] = s9 >>> 4 & 7L;
                decompressed[outOffset + 1] = s9 >>> 7 & 7L;
                decompressed[outOffset + 2] = s9 >>> 10 & 7L;
                decompressed[outOffset + 3] = s9 >>> 13 & 7L;
                decompressed[outOffset + 4] = s9 >>> 16 & 7L;
                decompressed[outOffset + 5] = s9 >>> 19 & 7L;
                decompressed[outOffset + 6] = s9 >>> 22 & 7L;
                decompressed[outOffset + 7] = s9 >>> 25 & 7L;
                decompressed[outOffset + 8] = s9 >>> 28 & 7L;
                decompressed[outOffset + 9] = s9 >>> 31 & 7L;
                decompressed[outOffset + 10] = s9 >>> 34 & 7L;
                decompressed[outOffset + 11] = s9 >>> 37 & 7L;
                decompressed[outOffset + 12] = s9 >>> 40 & 7L;
                decompressed[outOffset + 13] = s9 >>> 43 & 7L;
                decompressed[outOffset + 14] = s9 >>> 46 & 7L;
                decompressed[outOffset + 15] = s9 >>> 49 & 7L;
                decompressed[outOffset + 16] = s9 >>> 52 & 7L;
                decompressed[outOffset + 17] = s9 >>> 55 & 7L;
                decompressed[outOffset + 18] = s9 >>> 58 & 7L;
                decompressed[outOffset + 19] = s9 >>> 61 & 7L;
                return 20;
            }
            case 2: {
                decompressed[outOffset] = s9 >>> 4 & 3L;
                decompressed[outOffset + 1] = s9 >>> 6 & 3L;
                decompressed[outOffset + 2] = s9 >>> 8 & 3L;
                decompressed[outOffset + 3] = s9 >>> 10 & 3L;
                decompressed[outOffset + 4] = s9 >>> 12 & 3L;
                decompressed[outOffset + 5] = s9 >>> 14 & 3L;
                decompressed[outOffset + 6] = s9 >>> 16 & 3L;
                decompressed[outOffset + 7] = s9 >>> 18 & 3L;
                decompressed[outOffset + 8] = s9 >>> 20 & 3L;
                decompressed[outOffset + 9] = s9 >>> 22 & 3L;
                decompressed[outOffset + 10] = s9 >>> 24 & 3L;
                decompressed[outOffset + 11] = s9 >>> 26 & 3L;
                decompressed[outOffset + 12] = s9 >>> 28 & 3L;
                decompressed[outOffset + 13] = s9 >>> 30 & 3L;
                decompressed[outOffset + 14] = s9 >>> 32 & 3L;
                decompressed[outOffset + 15] = s9 >>> 34 & 3L;
                decompressed[outOffset + 16] = s9 >>> 36 & 3L;
                decompressed[outOffset + 17] = s9 >>> 38 & 3L;
                decompressed[outOffset + 18] = s9 >>> 40 & 3L;
                decompressed[outOffset + 19] = s9 >>> 42 & 3L;
                decompressed[outOffset + 20] = s9 >>> 44 & 3L;
                decompressed[outOffset + 21] = s9 >>> 46 & 3L;
                decompressed[outOffset + 22] = s9 >>> 48 & 3L;
                decompressed[outOffset + 23] = s9 >>> 50 & 3L;
                decompressed[outOffset + 24] = s9 >>> 52 & 3L;
                decompressed[outOffset + 25] = s9 >>> 54 & 3L;
                decompressed[outOffset + 26] = s9 >>> 56 & 3L;
                decompressed[outOffset + 27] = s9 >>> 58 & 3L;
                decompressed[outOffset + 28] = s9 >>> 60 & 3L;
                decompressed[outOffset + 29] = s9 >>> 62 & 3L;
                return 30;
            }
            case 1: {
                decompressed[outOffset] = s9 >>> 4 & 1L;
                decompressed[outOffset + 1] = s9 >>> 5 & 1L;
                decompressed[outOffset + 2] = s9 >>> 6 & 1L;
                decompressed[outOffset + 3] = s9 >>> 7 & 1L;
                decompressed[outOffset + 4] = s9 >>> 8 & 1L;
                decompressed[outOffset + 5] = s9 >>> 9 & 1L;
                decompressed[outOffset + 6] = s9 >>> 10 & 1L;
                decompressed[outOffset + 7] = s9 >>> 11 & 1L;
                decompressed[outOffset + 8] = s9 >>> 12 & 1L;
                decompressed[outOffset + 9] = s9 >>> 13 & 1L;
                decompressed[outOffset + 10] = s9 >>> 14 & 1L;
                decompressed[outOffset + 11] = s9 >>> 15 & 1L;
                decompressed[outOffset + 12] = s9 >>> 16 & 1L;
                decompressed[outOffset + 13] = s9 >>> 17 & 1L;
                decompressed[outOffset + 14] = s9 >>> 18 & 1L;
                decompressed[outOffset + 15] = s9 >>> 19 & 1L;
                decompressed[outOffset + 16] = s9 >>> 20 & 1L;
                decompressed[outOffset + 17] = s9 >>> 21 & 1L;
                decompressed[outOffset + 18] = s9 >>> 22 & 1L;
                decompressed[outOffset + 19] = s9 >>> 23 & 1L;
                decompressed[outOffset + 20] = s9 >>> 24 & 1L;
                decompressed[outOffset + 21] = s9 >>> 25 & 1L;
                decompressed[outOffset + 22] = s9 >>> 26 & 1L;
                decompressed[outOffset + 23] = s9 >>> 27 & 1L;
                decompressed[outOffset + 24] = s9 >>> 28 & 1L;
                decompressed[outOffset + 25] = s9 >>> 29 & 1L;
                decompressed[outOffset + 26] = s9 >>> 30 & 1L;
                decompressed[outOffset + 27] = s9 >>> 31 & 1L;
                decompressed[outOffset + 28] = s9 >>> 32 & 1L;
                decompressed[outOffset + 29] = s9 >>> 33 & 1L;
                decompressed[outOffset + 30] = s9 >>> 34 & 1L;
                decompressed[outOffset + 31] = s9 >>> 35 & 1L;
                decompressed[outOffset + 32] = s9 >>> 36 & 1L;
                decompressed[outOffset + 33] = s9 >>> 37 & 1L;
                decompressed[outOffset + 34] = s9 >>> 38 & 1L;
                decompressed[outOffset + 35] = s9 >>> 39 & 1L;
                decompressed[outOffset + 36] = s9 >>> 40 & 1L;
                decompressed[outOffset + 37] = s9 >>> 41 & 1L;
                decompressed[outOffset + 38] = s9 >>> 42 & 1L;
                decompressed[outOffset + 39] = s9 >>> 43 & 1L;
                decompressed[outOffset + 40] = s9 >>> 44 & 1L;
                decompressed[outOffset + 41] = s9 >>> 45 & 1L;
                decompressed[outOffset + 42] = s9 >>> 46 & 1L;
                decompressed[outOffset + 43] = s9 >>> 47 & 1L;
                decompressed[outOffset + 44] = s9 >>> 48 & 1L;
                decompressed[outOffset + 45] = s9 >>> 49 & 1L;
                decompressed[outOffset + 46] = s9 >>> 50 & 1L;
                decompressed[outOffset + 47] = s9 >>> 51 & 1L;
                decompressed[outOffset + 48] = s9 >>> 52 & 1L;
                decompressed[outOffset + 49] = s9 >>> 53 & 1L;
                decompressed[outOffset + 50] = s9 >>> 54 & 1L;
                decompressed[outOffset + 51] = s9 >>> 55 & 1L;
                decompressed[outOffset + 52] = s9 >>> 56 & 1L;
                decompressed[outOffset + 53] = s9 >>> 57 & 1L;
                decompressed[outOffset + 54] = s9 >>> 58 & 1L;
                decompressed[outOffset + 55] = s9 >>> 59 & 1L;
                decompressed[outOffset + 56] = s9 >>> 60 & 1L;
                decompressed[outOffset + 57] = s9 >>> 61 & 1L;
                decompressed[outOffset + 58] = s9 >>> 62 & 1L;
                decompressed[outOffset + 59] = s9 >>> 63 & 1L;
                return 60;
            }
        }
        throw new IllegalArgumentException("Unknown Simple9 status: " + (s9 >>> 60));
    }

    public static void compress(LongBuffer compressedBuffer, long[] unCompressedData, int offset, int size) {
        while (size > 0) {
            int encoded = Simple64.compressSingle(unCompressedData, offset, size, compressedBuffer);
            offset += encoded;
            size -= encoded;
        }
    }

    public static int decompress(LongBuffer compressedBuffer, long[] unCompressedData) {
        int totalOut = 0;
        compressedBuffer.rewind();
        int unComprSize = unCompressedData.length;
        while (unComprSize > 0) {
            int decoded = Simple64.decompressSingle(compressedBuffer.get(), unCompressedData, totalOut);
            unComprSize -= decoded;
            totalOut += decoded;
        }
        return totalOut;
    }
}

