/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous;

import java.util.Collections;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.DelegatingAnalyzerWrapper;

public final class PerFieldAnalyzerWrapper
extends DelegatingAnalyzerWrapper {
    private final Analyzer defaultAnalyzer;
    private final Map<String, Analyzer> fieldAnalyzers;

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this(defaultAnalyzer, null);
    }

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer, Map<String, Analyzer> fieldAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
        this.fieldAnalyzers = fieldAnalyzers != null ? fieldAnalyzers : Collections.emptyMap();
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.fieldAnalyzers.get(fieldName);
        return analyzer != null ? analyzer : this.defaultAnalyzer;
    }

    public String toString() {
        return "PerFieldAnalyzerWrapper(" + this.fieldAnalyzers + ", default=" + this.defaultAnalyzer + ")";
    }
}

