/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.document;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.LongPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MultiRangeQuery;

public class LongPointMultiRangeBuilder
extends MultiRangeQuery.Builder {
    public LongPointMultiRangeBuilder(String field, int numDims) {
        super(field, 8, numDims);
    }

    @Override
    public MultiRangeQuery build() {
        return new MultiRangeQuery(this.field, this.numDims, this.bytesPerDim, this.clauses){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Long.toString(LongPoint.decodeDimension(value, 0));
            }
        };
    }

    public void add(long[] lowerValue, long[] upperValue) {
        if (upperValue.length != this.numDims || lowerValue.length != this.numDims) {
            throw new IllegalArgumentException("Passed in range does not conform to specified dimensions");
        }
        for (int i = 0; i < this.numDims; ++i) {
            if (upperValue[i] >= lowerValue[i]) continue;
            throw new IllegalArgumentException("Upper value of range should be greater than lower value of range");
        }
        this.add(LongPoint.pack((long[])lowerValue).bytes, LongPoint.pack((long[])upperValue).bytes);
    }
}

