/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.document;

import java.util.Arrays;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.ShapeField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.ShapeQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYEncodingUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYGeometry;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.NumericUtils;

final class XYShapeQuery
extends ShapeQuery {
    final XYGeometry[] geometries;
    private final Component2D component2D;

    XYShapeQuery(String field, ShapeField.QueryRelation queryRelation, XYGeometry ... geometries) {
        super(field, queryRelation);
        this.component2D = XYGeometry.create(geometries);
        this.geometries = (XYGeometry[])geometries.clone();
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minYOffset));
        double minLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minXOffset));
        double maxLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxYOffset));
        double maxLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxXOffset));
        return this.component2D.relate(minLon, maxLon, minLat, maxLat);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = XYEncodingUtils.decode(scratchTriangle.aY);
        double alon = XYEncodingUtils.decode(scratchTriangle.aX);
        double blat = XYEncodingUtils.decode(scratchTriangle.bY);
        double blon = XYEncodingUtils.decode(scratchTriangle.bX);
        double clat = XYEncodingUtils.decode(scratchTriangle.cY);
        double clon = XYEncodingUtils.decode(scratchTriangle.cX);
        switch (queryRelation) {
            case INTERSECTS: {
                return this.component2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            case WITHIN: {
                return this.component2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case DISJOINT: {
                return this.component2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = XYEncodingUtils.decode(scratchTriangle.aY);
        double alon = XYEncodingUtils.decode(scratchTriangle.aX);
        double blat = XYEncodingUtils.decode(scratchTriangle.bY);
        double blon = XYEncodingUtils.decode(scratchTriangle.bX);
        double clat = XYEncodingUtils.decode(scratchTriangle.cY);
        double clon = XYEncodingUtils.decode(scratchTriangle.cX);
        return this.component2D.withinTriangle(alon, alat, scratchTriangle.ab, blon, blat, scratchTriangle.bc, clon, clat, scratchTriangle.ca);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("[");
        for (int i = 0; i < this.geometries.length; ++i) {
            sb.append(this.geometries[i].toString());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.geometries, ((XYShapeQuery)o).geometries);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.geometries);
        return hash;
    }
}

