/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.geo;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.Point;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.PointValues;

final class Point2D
implements Component2D {
    private final double x;
    private final double y;

    private Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double getMinX() {
        return this.x;
    }

    @Override
    public double getMaxX() {
        return this.x;
    }

    @Override
    public double getMinY() {
        return this.y;
    }

    @Override
    public double getMaxY() {
        return this.y;
    }

    @Override
    public boolean contains(double x, double y) {
        return x == this.x && y == this.y;
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.containsPoint(this.x, this.y, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public PointValues.Relation relateTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        if (ax == bx && bx == cx && ay == by && by == cy) {
            return this.contains(ax, ay) ? PointValues.Relation.CELL_INSIDE_QUERY : PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.x, this.y, ax, ay, bx, by, cx, cy)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.x, this.y, aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    static Component2D create(Point point) {
        return new Point2D(GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.encodeLongitude(point.getLon())), GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitude(point.getLat())));
    }

    static Component2D create(XYPoint xyPoint) {
        return new Point2D(xyPoint.getX(), xyPoint.getY());
    }
}

