/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import java.io.IOException;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FilterMergePolicy;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.MergeTrigger;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SegmentInfos;

public class OneMergeWrappingMergePolicy
extends FilterMergePolicy {
    private final UnaryOperator<MergePolicy.OneMerge> wrapOneMerge;

    public OneMergeWrappingMergePolicy(MergePolicy in, UnaryOperator<MergePolicy.OneMerge> wrapOneMerge) {
        super(in);
        this.wrapOneMerge = wrapOneMerge;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.wrapSpec(this.in.findMerges(mergeTrigger, segmentInfos, mergeContext));
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.wrapSpec(this.in.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, mergeContext));
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.wrapSpec(this.in.findForcedDeletesMerges(segmentInfos, mergeContext));
    }

    private MergePolicy.MergeSpecification wrapSpec(MergePolicy.MergeSpecification spec) {
        MergePolicy.MergeSpecification wrapped;
        MergePolicy.MergeSpecification mergeSpecification = wrapped = spec == null ? null : new MergePolicy.MergeSpecification();
        if (wrapped != null) {
            for (MergePolicy.OneMerge merge : spec.merges) {
                wrapped.add((MergePolicy.OneMerge)this.wrapOneMerge.apply(merge));
            }
        }
        return wrapped;
    }
}

