/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;

public abstract class ValueSourceScorer
extends Scorer {
    protected final FunctionValues values;
    private final TwoPhaseIterator twoPhaseIterator;
    private final DocIdSetIterator disi;

    protected ValueSourceScorer(Weight weight, LeafReaderContext readerContext, FunctionValues values) {
        super(weight);
        this.values = values;
        DocIdSetIterator approximation = DocIdSetIterator.all(readerContext.reader().maxDoc());
        this.twoPhaseIterator = new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                return ValueSourceScorer.this.matches(this.approximation.docID());
            }

            @Override
            public float matchCost() {
                return 100.0f;
            }
        };
        this.disi = TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator);
    }

    public abstract boolean matches(int var1) throws IOException;

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhaseIterator;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        float score = this.values.floatVal(this.disi.docID());
        return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }
}

