/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;

public final class NormsFieldExistsQuery
extends Query {
    private final String field;

    public NormsFieldExistsQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getField() {
        return this.field;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((NormsFieldExistsQuery)other).field);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.field.hashCode();
    }

    @Override
    public String toString(String field) {
        return "NormsFieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(NormsFieldExistsQuery.this.field);
                if (fieldInfo == null || !fieldInfo.hasNorms()) {
                    return null;
                }
                LeafReader reader = context.reader();
                NumericDocValues iterator = reader.getNormValues(NormsFieldExistsQuery.this.field);
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }
}

