/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldComparatorSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;

public class SortField {
    public static final SortField FIELD_SCORE = new SortField(null, Type.SCORE);
    public static final SortField FIELD_DOC = new SortField(null, Type.DOC);
    private String field;
    private Type type;
    boolean reverse = false;
    private FieldComparatorSource comparatorSource;
    protected Object missingValue = null;
    public static final Object STRING_FIRST = new Object(){

        public String toString() {
            return "SortField.STRING_FIRST";
        }
    };
    public static final Object STRING_LAST = new Object(){

        public String toString() {
            return "SortField.STRING_LAST";
        }
    };
    private Comparator<BytesRef> bytesComparator = Comparator.naturalOrder();

    public SortField(String field, Type type) {
        this.initFieldType(field, type);
    }

    public SortField(String field, Type type, boolean reverse) {
        this.initFieldType(field, type);
        this.reverse = reverse;
    }

    public Object getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(Object missingValue) {
        if (this.type == Type.STRING || this.type == Type.STRING_VAL) {
            if (missingValue != STRING_FIRST && missingValue != STRING_LAST) {
                throw new IllegalArgumentException("For STRING type, missing value must be either STRING_FIRST or STRING_LAST");
            }
        } else if (this.type == Type.INT) {
            if (missingValue != null && missingValue.getClass() != Integer.class) {
                throw new IllegalArgumentException("Missing values for Type.INT can only be of type java.lang.Integer, but got " + missingValue.getClass());
            }
        } else if (this.type == Type.LONG) {
            if (missingValue != null && missingValue.getClass() != Long.class) {
                throw new IllegalArgumentException("Missing values for Type.LONG can only be of type java.lang.Long, but got " + missingValue.getClass());
            }
        } else if (this.type == Type.FLOAT) {
            if (missingValue != null && missingValue.getClass() != Float.class) {
                throw new IllegalArgumentException("Missing values for Type.FLOAT can only be of type java.lang.Float, but got " + missingValue.getClass());
            }
        } else if (this.type == Type.DOUBLE) {
            if (missingValue != null && missingValue.getClass() != Double.class) {
                throw new IllegalArgumentException("Missing values for Type.DOUBLE can only be of type java.lang.Double, but got " + missingValue.getClass());
            }
        } else {
            throw new IllegalArgumentException("Missing value only works for numeric or STRING types");
        }
        this.missingValue = missingValue;
    }

    public SortField(String field, FieldComparatorSource comparator) {
        this.initFieldType(field, Type.CUSTOM);
        this.comparatorSource = comparator;
    }

    public SortField(String field, FieldComparatorSource comparator, boolean reverse) {
        this.initFieldType(field, Type.CUSTOM);
        this.reverse = reverse;
        this.comparatorSource = comparator;
    }

    private void initFieldType(String field, Type type) {
        this.type = type;
        if (field == null) {
            if (type != Type.SCORE && type != Type.DOC) {
                throw new IllegalArgumentException("field can only be null when type is SCORE or DOC");
            }
        } else {
            this.field = field;
        }
    }

    public String getField() {
        return this.field;
    }

    public Type getType() {
        return this.type;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public FieldComparatorSource getComparatorSource() {
        return this.comparatorSource;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        switch (this.type) {
            case SCORE: {
                buffer.append("<score>");
                break;
            }
            case DOC: {
                buffer.append("<doc>");
                break;
            }
            case STRING: {
                buffer.append("<string: \"").append(this.field).append("\">");
                break;
            }
            case STRING_VAL: {
                buffer.append("<string_val: \"").append(this.field).append("\">");
                break;
            }
            case INT: {
                buffer.append("<int: \"").append(this.field).append("\">");
                break;
            }
            case LONG: {
                buffer.append("<long: \"").append(this.field).append("\">");
                break;
            }
            case FLOAT: {
                buffer.append("<float: \"").append(this.field).append("\">");
                break;
            }
            case DOUBLE: {
                buffer.append("<double: \"").append(this.field).append("\">");
                break;
            }
            case CUSTOM: {
                buffer.append("<custom:\"").append(this.field).append("\": ").append(this.comparatorSource).append('>');
                break;
            }
            case REWRITEABLE: {
                buffer.append("<rewriteable: \"").append(this.field).append("\">");
                break;
            }
            default: {
                buffer.append("<???: \"").append(this.field).append("\">");
            }
        }
        if (this.reverse) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortField)) {
            return false;
        }
        SortField other = (SortField)o;
        return Objects.equals(other.field, this.field) && other.type == this.type && other.reverse == this.reverse && Objects.equals(this.comparatorSource, other.comparatorSource) && Objects.equals(this.missingValue, other.missingValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.type, this.reverse, this.comparatorSource, this.missingValue});
    }

    public void setBytesComparator(Comparator<BytesRef> b) {
        this.bytesComparator = b;
    }

    public Comparator<BytesRef> getBytesComparator() {
        return this.bytesComparator;
    }

    public FieldComparator<?> getComparator(int numHits, int sortPos) {
        switch (this.type) {
            case SCORE: {
                return new FieldComparator.RelevanceComparator(numHits);
            }
            case DOC: {
                return new FieldComparator.DocComparator(numHits);
            }
            case INT: {
                return new FieldComparator.IntComparator(numHits, this.field, (Integer)this.missingValue);
            }
            case FLOAT: {
                return new FieldComparator.FloatComparator(numHits, this.field, (Float)this.missingValue);
            }
            case LONG: {
                return new FieldComparator.LongComparator(numHits, this.field, (Long)this.missingValue);
            }
            case DOUBLE: {
                return new FieldComparator.DoubleComparator(numHits, this.field, (Double)this.missingValue);
            }
            case CUSTOM: {
                assert (this.comparatorSource != null);
                return this.comparatorSource.newComparator(this.field, numHits, sortPos, this.reverse);
            }
            case STRING: {
                return new FieldComparator.TermOrdValComparator(numHits, this.field, this.missingValue == STRING_LAST);
            }
            case STRING_VAL: {
                return new FieldComparator.TermValComparator(numHits, this.field, this.missingValue == STRING_LAST);
            }
            case REWRITEABLE: {
                throw new IllegalStateException("SortField needs to be rewritten through Sort.rewrite(..) and SortField.rewrite(..)");
            }
        }
        throw new IllegalStateException("Illegal sort type: " + (Object)((Object)this.type));
    }

    public SortField rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    public boolean needsScores() {
        return this.type == Type.SCORE;
    }

    public static enum Type {
        SCORE,
        DOC,
        STRING,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        CUSTOM,
        STRING_VAL,
        REWRITEABLE;

    }
}

