/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.BasicModel;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.BasicStats;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.SimilarityBase;

public class BasicModelIF
extends BasicModel {
    @Override
    public final double score(BasicStats stats, double tfn, double aeTimes1pTfn) {
        long N = stats.getNumberOfDocuments();
        long F = stats.getTotalTermFreq();
        double A = SimilarityBase.log2(1.0 + (double)(N + 1L) / ((double)F + 0.5));
        return A * aeTimes1pTfn * (1.0 - 1.0 / (1.0 + tfn));
    }

    @Override
    public Explanation explain(BasicStats stats, double tfn, double aeTimes1pTfn) {
        return Explanation.match((Number)Float.valueOf((float)(this.score(stats, tfn, aeTimes1pTfn) * (1.0 + tfn) / aeTimes1pTfn)), this.getClass().getSimpleName() + ", computed as tfn * log2(1 + (N + 1) / (F + 0.5)) from:", Explanation.match((Number)Float.valueOf((float)tfn), "tfn, normalized term frequency", new Explanation[0]), Explanation.match((Number)stats.getNumberOfDocuments(), "N, total number of documents with field", new Explanation[0]), Explanation.match((Number)stats.getTotalTermFreq(), "F, total number of occurrences of term across all documents", new Explanation[0]));
    }

    @Override
    public String toString() {
        return "I(F)";
    }
}

