/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.Polygon;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.Geo3DUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.PointInGeo3DShapeQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoCircle;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPath;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.NumericUtils;

public final class Geo3DPoint
extends Field {
    protected final PlanetModel planetModel;
    public static final FieldType TYPE = new FieldType();

    public Geo3DPoint(String name, double lat, double lon) {
        this(name, PlanetModel.WGS84, lat, lon);
    }

    public Geo3DPoint(String name, double x, double y, double z) {
        this(name, PlanetModel.WGS84, x, y, z);
    }

    public Geo3DPoint(String name, PlanetModel planetModel, double x, double y, double z) {
        super(name, TYPE);
        this.planetModel = planetModel;
        this.fillFieldsData(planetModel, x, y, z);
    }

    public Geo3DPoint(String name, PlanetModel planetModel, double latitude, double longitude) {
        super(name, TYPE);
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        this.planetModel = planetModel;
        GeoPoint point = new GeoPoint(planetModel, Geo3DUtil.fromDegrees(latitude), Geo3DUtil.fromDegrees(longitude));
        this.fillFieldsData(planetModel, point.x, point.y, point.z);
    }

    public static Query newDistanceQuery(String field, PlanetModel planetModel, double latitude, double longitude, double radiusMeters) {
        GeoCircle shape = Geo3DUtil.fromDistance(planetModel, latitude, longitude, radiusMeters);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newBoxQuery(String field, PlanetModel planetModel, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoBBox shape = Geo3DUtil.fromBox(planetModel, minLatitude, maxLatitude, minLongitude, maxLongitude);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newPolygonQuery(String field, PlanetModel planetModel, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromPolygon(planetModel, polygons);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newLargePolygonQuery(String field, PlanetModel planetModel, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromLargePolygon(planetModel, polygons);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newPathQuery(String field, double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters, PlanetModel planetModel) {
        GeoPath shape = Geo3DUtil.fromPath(planetModel, pathLatitudes, pathLongitudes, pathWidthMeters);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    private void fillFieldsData(PlanetModel planetModel, double x, double y, double z) {
        byte[] bytes = new byte[12];
        Geo3DPoint.encodeDimension(x, bytes, 0, planetModel);
        Geo3DPoint.encodeDimension(y, bytes, 4, planetModel);
        Geo3DPoint.encodeDimension(z, bytes, 8, planetModel);
        this.fieldsData = new BytesRef(bytes);
    }

    public static void encodeDimension(double value, byte[] bytes, int offset, PlanetModel planetModel) {
        NumericUtils.intToSortableBytes(planetModel.encodeValue(value), bytes, offset);
    }

    public static double decodeDimension(byte[] value, int offset, PlanetModel planetModel) {
        return planetModel.decodeValue(NumericUtils.sortableBytesToInt(value, offset));
    }

    public static Query newShapeQuery(String field, GeoShape shape) {
        return new PointInGeo3DShapeQuery(field, shape);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        result.append(" x=").append(Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset, this.planetModel));
        result.append(" y=").append(Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset + 4, this.planetModel));
        result.append(" z=").append(Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset + 8, this.planetModel));
        result.append('>');
        return result.toString();
    }

    static {
        TYPE.setDimensions(3, 4);
        TYPE.freeze();
    }
}

