/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.BufferedIndexInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.FSDirectory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.FSLockFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.IOContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.LockFactory;

public class SimpleFSDirectory
extends FSDirectory {
    public SimpleFSDirectory(Path path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public SimpleFSDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = this.directory.resolve(name);
        SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);
        return new SimpleFSIndexInput("SimpleFSIndexInput(path=\"" + path + "\")", channel, context);
    }

    static final class SimpleFSIndexInput
    extends BufferedIndexInput {
        private static final int CHUNK_SIZE = 16384;
        protected final SeekableByteChannel channel;
        boolean isClone = false;
        protected final long off;
        protected final long end;
        private ByteBuffer byteBuf;

        public SimpleFSIndexInput(String resourceDesc, SeekableByteChannel channel, IOContext context) throws IOException {
            super(resourceDesc, context);
            this.channel = channel;
            this.off = 0L;
            this.end = channel.size();
        }

        public SimpleFSIndexInput(String resourceDesc, SeekableByteChannel channel, long off, long length, int bufferSize) {
            super(resourceDesc, bufferSize);
            this.channel = channel;
            this.off = off;
            this.end = off + length;
            this.isClone = true;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.channel.close();
            }
        }

        @Override
        public SimpleFSIndexInput clone() {
            SimpleFSIndexInput clone = (SimpleFSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            if (offset < 0L || length < 0L || offset + length > this.length()) {
                throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + this);
            }
            return new SimpleFSIndexInput(this.getFullSliceDescription(sliceDescription), this.channel, this.off + offset, length, this.getBufferSize());
        }

        @Override
        public final long length() {
            return this.end - this.off;
        }

        @Override
        protected void newBuffer(byte[] newBuffer) {
            super.newBuffer(newBuffer);
            this.byteBuf = ByteBuffer.wrap(newBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            ByteBuffer bb;
            if (b == this.buffer) {
                assert (this.byteBuf != null);
                bb = this.byteBuf;
                this.byteBuf.clear().position(offset);
            } else {
                bb = ByteBuffer.wrap(b, offset, len);
            }
            SeekableByteChannel seekableByteChannel = this.channel;
            synchronized (seekableByteChannel) {
                long pos = this.getFilePointer() + this.off;
                if (pos + (long)len > this.end) {
                    throw new EOFException("read past EOF: " + this);
                }
                try {
                    int readLength;
                    int i;
                    this.channel.position(pos);
                    for (readLength = len; readLength > 0; readLength -= i) {
                        int toRead = Math.min(16384, readLength);
                        bb.limit(bb.position() + toRead);
                        assert (bb.remaining() == toRead);
                        i = this.channel.read(bb);
                        if (i < 0) {
                            throw new EOFException("read past EOF: " + this + " off: " + offset + " len: " + len + " pos: " + pos + " chunkLen: " + toRead + " end: " + this.end);
                        }
                        assert (i > 0) : "SeekableByteChannel.read with non zero-length bb.remaining() must always read at least one byte (Channel is in blocking mode, see spec of ReadableByteChannel)";
                        pos += (long)i;
                    }
                    assert (readLength == 0);
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage() + ": " + this, ioe);
                }
            }
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
            if (pos > this.length()) {
                throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + this);
            }
        }
    }
}

