/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst.Outputs;

public final class ListOfOutputs<T>
extends Outputs<Object> {
    private final Outputs<T> outputs;
    private static final long BASE_LIST_NUM_BYTES = RamUsageEstimator.shallowSizeOf(new ArrayList());

    public ListOfOutputs(Outputs<T> outputs) {
        this.outputs = outputs;
    }

    @Override
    public Object common(Object output1, Object output2) {
        return this.outputs.common(output1, output2);
    }

    @Override
    public Object subtract(Object object, Object inc) {
        return this.outputs.subtract(object, inc);
    }

    @Override
    public Object add(Object prefix, Object output) {
        assert (!(prefix instanceof List));
        if (!(output instanceof List)) {
            return this.outputs.add(prefix, output);
        }
        List outputList = (List)output;
        ArrayList<Object> addedList = new ArrayList<Object>(outputList.size());
        for (Object _output : outputList) {
            addedList.add(this.outputs.add(prefix, _output));
        }
        return addedList;
    }

    @Override
    public void write(Object output, DataOutput out) throws IOException {
        assert (!(output instanceof List));
        this.outputs.write(output, out);
    }

    @Override
    public void writeFinalOutput(Object output, DataOutput out) throws IOException {
        if (!(output instanceof List)) {
            out.writeVInt(1);
            this.outputs.write(output, out);
        } else {
            List outputList = (List)output;
            out.writeVInt(outputList.size());
            for (Object eachOutput : outputList) {
                this.outputs.write(eachOutput, out);
            }
        }
    }

    @Override
    public Object read(DataInput in) throws IOException {
        return this.outputs.read(in);
    }

    @Override
    public void skipOutput(DataInput in) throws IOException {
        this.outputs.skipOutput(in);
    }

    @Override
    public Object readFinalOutput(DataInput in) throws IOException {
        int count = in.readVInt();
        if (count == 1) {
            return this.outputs.read(in);
        }
        ArrayList<T> outputList = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            outputList.add(this.outputs.read(in));
        }
        return outputList;
    }

    @Override
    public void skipFinalOutput(DataInput in) throws IOException {
        int count = in.readVInt();
        for (int i = 0; i < count; ++i) {
            this.outputs.skipOutput(in);
        }
    }

    @Override
    public Object getNoOutput() {
        return this.outputs.getNoOutput();
    }

    @Override
    public String outputToString(Object output) {
        if (!(output instanceof List)) {
            return this.outputs.outputToString(output);
        }
        List outputList = (List)output;
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < outputList.size(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.outputs.outputToString(outputList.get(i)));
        }
        b.append(']');
        return b.toString();
    }

    @Override
    public Object merge(Object first, Object second) {
        ArrayList<Object> outputList = new ArrayList<Object>();
        if (!(first instanceof List)) {
            outputList.add(first);
        } else {
            outputList.addAll((List)first);
        }
        if (!(second instanceof List)) {
            outputList.add(second);
        } else {
            outputList.addAll((List)second);
        }
        return outputList;
    }

    public String toString() {
        return "OneOrMoreOutputs(" + this.outputs + ")";
    }

    public List<T> asList(Object output) {
        if (!(output instanceof List)) {
            ArrayList<Object> result = new ArrayList<Object>(1);
            result.add(output);
            return result;
        }
        return (List)output;
    }

    @Override
    public long ramBytesUsed(Object output) {
        long bytes = 0L;
        if (output instanceof List) {
            bytes += BASE_LIST_NUM_BYTES;
            List outputList = (List)output;
            for (Object _output : outputList) {
                bytes += this.outputs.ramBytesUsed(_output);
            }
            bytes += (long)(2 * outputList.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        } else {
            bytes += this.outputs.ramBytesUsed(output);
        }
        return bytes;
    }
}

