/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst.BytesStore;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst.FST;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst.FSTStore;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst.ReverseBytesReader;

public final class OnHeapFSTStore
implements FSTStore {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OnHeapFSTStore.class);
    private BytesStore bytes;
    private byte[] bytesArray;
    private final int maxBlockBits;

    public OnHeapFSTStore(int maxBlockBits) {
        if (maxBlockBits < 1 || maxBlockBits > 30) {
            throw new IllegalArgumentException("maxBlockBits should be 1 .. 30; got " + maxBlockBits);
        }
        this.maxBlockBits = maxBlockBits;
    }

    @Override
    public void init(DataInput in, long numBytes) throws IOException {
        if (numBytes > (long)(1 << this.maxBlockBits)) {
            this.bytes = new BytesStore(in, numBytes, 1 << this.maxBlockBits);
        } else {
            this.bytesArray = new byte[(int)numBytes];
            in.readBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }

    @Override
    public long size() {
        if (this.bytesArray != null) {
            return this.bytesArray.length;
        }
        return this.bytes.ramBytesUsed();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.size();
    }

    @Override
    public FST.BytesReader getReverseBytesReader() {
        if (this.bytesArray != null) {
            return new ReverseBytesReader(this.bytesArray);
        }
        return this.bytes.getReverseReader();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.bytes != null) {
            long numBytes = this.bytes.getPosition();
            out.writeVLong(numBytes);
            this.bytes.writeTo(out);
        } else {
            assert (this.bytesArray != null);
            out.writeVLong(this.bytesArray.length);
            out.writeBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }
}

