/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.util.packed;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.packed.AbstractBlockPackedWriter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.packed.PackedInts;

public final class MonotonicBlockPackedWriter
extends AbstractBlockPackedWriter {
    public MonotonicBlockPackedWriter(DataOutput out, int blockSize) {
        super(out, blockSize);
    }

    @Override
    public void add(long l) throws IOException {
        assert (l >= 0L);
        super.add(l);
    }

    @Override
    protected void flush() throws IOException {
        assert (this.off > 0);
        float avg = this.off == 1 ? 0.0f : (float)(this.values[this.off - 1] - this.values[0]) / (float)(this.off - 1);
        long min = this.values[0];
        for (int i = 1; i < this.off; ++i) {
            long actual = this.values[i];
            long expected = MonotonicBlockPackedReader.expected(min, avg, i);
            if (expected <= actual) continue;
            min -= expected - actual;
        }
        long maxDelta = 0L;
        for (int i = 0; i < this.off; ++i) {
            this.values[i] = this.values[i] - MonotonicBlockPackedReader.expected(min, avg, i);
            maxDelta = Math.max(maxDelta, this.values[i]);
        }
        this.out.writeZLong(min);
        this.out.writeInt(Float.floatToIntBits(avg));
        if (maxDelta == 0L) {
            this.out.writeVInt(0);
        } else {
            int bitsRequired = PackedInts.bitsRequired(maxDelta);
            this.out.writeVInt(bitsRequired);
            this.writeValues(bitsRequired);
        }
        this.off = 0;
    }
}

