/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Assertions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Build;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.SuppressForbidden;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.monitor.jvm.JvmInfo;

public class Version
implements Comparable<Version>,
ToXContentFragment {
    public static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = new Version(0, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LATEST);
    public static final Version V_6_0_0_alpha1 = new Version(6000001, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final Version V_6_0_0_alpha2 = new Version(6000002, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final Version V_6_0_0_beta1 = new Version(6000026, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final Version V_6_0_0_beta2 = new Version(6000027, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final Version V_6_0_0_rc1 = new Version(6000051, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final Version V_6_0_0_rc2 = new Version(6000052, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final Version V_6_0_0 = new Version(6000099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final Version V_6_0_1 = new Version(6000199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final Version V_6_1_0 = new Version(6010099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final Version V_6_1_1 = new Version(0x5BB557, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final Version V_6_1_2 = new Version(0x5BB5BB, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final Version V_6_1_3 = new Version(6010399, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final Version V_6_1_4 = new Version(6010499, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_1_0);
    private static final org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version LUCENE_7_2_1 = org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.fromBits(7, 2, 1);
    private static final org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version LUCENE_7_7_3 = org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.fromBits(7, 7, 3);
    public static final Version V_6_2_0 = new Version(6020099, LUCENE_7_2_1);
    public static final Version V_6_2_1 = new Version(6020199, LUCENE_7_2_1);
    public static final Version V_6_2_2 = new Version(6020299, LUCENE_7_2_1);
    public static final Version V_6_2_3 = new Version(6020399, LUCENE_7_2_1);
    public static final Version V_6_2_4 = new Version(6020499, LUCENE_7_2_1);
    public static final Version V_6_3_0 = new Version(6030099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_3_1);
    public static final Version V_6_3_1 = new Version(6030199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_3_1);
    public static final Version V_6_3_2 = new Version(6030299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_3_1);
    public static final Version V_6_4_0 = new Version(6040099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final Version V_6_4_1 = new Version(6040199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final Version V_6_4_2 = new Version(6040299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final Version V_6_4_3 = new Version(6040399, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final Version V_6_5_0 = new Version(6050099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final Version V_6_5_1 = new Version(6050199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final Version V_6_5_2 = new Version(6050299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final Version V_6_5_3 = new Version(6050399, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final Version V_6_5_4 = new Version(6050499, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final Version V_6_6_0 = new Version(6060099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_6_0);
    public static final Version V_6_6_1 = new Version(6060199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_6_0);
    public static final Version V_6_6_2 = new Version(6060299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_6_0);
    public static final Version V_6_7_0 = new Version(6070099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final Version V_6_7_1 = new Version(6070199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final Version V_6_7_2 = new Version(6070299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final Version V_6_8_0 = new Version(6080099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final Version V_6_8_1 = new Version(6080199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final Version V_6_8_2 = new Version(6080299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final Version V_6_8_3 = new Version(6080399, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final Version V_6_8_4 = new Version(6080499, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_2);
    public static final Version V_6_8_5 = new Version(6080599, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_2);
    public static final Version V_6_8_6 = new Version(6080699, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_2);
    public static final Version V_6_8_7 = new Version(6080799, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_2);
    public static final Version V_6_8_8 = new Version(6080899, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_7_7_2);
    public static final Version V_6_8_9 = new Version(6080999, LUCENE_7_7_3);
    public static final Version V_6_8_10 = new Version(6081099, LUCENE_7_7_3);
    public static final Version V_6_8_11 = new Version(6081199, LUCENE_7_7_3);
    public static final Version V_7_0_0 = new Version(7000099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_0_1 = new Version(7000199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_1_0 = new Version(7010099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_1_1 = new Version(7010199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_2_0 = new Version(7020099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_2_1 = new Version(7020199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_3_0 = new Version(7030099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final Version V_7_3_1 = new Version(7030199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final Version V_7_3_2 = new Version(7030299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final Version V_7_4_0 = new Version(7040099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final Version V_7_4_1 = new Version(7040199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final Version V_7_4_2 = new Version(7040299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final Version V_7_5_0 = new Version(7050099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final Version V_7_5_1 = new Version(7050199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final Version V_7_5_2 = new Version(7050299, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final Version V_7_6_0 = new Version(7060099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_7_6_1 = new Version(7060199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_7_6_2 = new Version(0x6BBB4B, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_7_7_0 = new Version(7070099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_7_7_1 = new Version(7070199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_7_8_0 = new Version(7080099, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_7_8_1;
    public static final Version CURRENT;
    private static final ImmutableOpenIntMap<Version> idToVersion;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version luceneVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        if (idToVersion.containsKey(id)) {
            return idToVersion.get(id);
        }
        switch (id) {
            case 0: {
                return V_EMPTY;
            }
        }
        List<Version> versions = DeclaredVersionsHolder.DECLARED_VERSIONS;
        Version tmp = new Version(id, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LATEST);
        int index = Collections.binarySearch(versions, tmp);
        if (index < 0) {
            index = -2 - index;
        } else assert (false) : "Version [" + tmp + "] is declared but absent from the switch statement in Version#fromId";
        org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version luceneVersion = index == -1 ? org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.fromBits(versions.get((int)0).luceneVersion.major - 1, 0, 0) : versions.get((int)index).luceneVersion;
        return new Version(id, luceneVersion);
    }

    public static Version indexCreated(Settings indexSettings) {
        Version indexVersion = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (indexVersion == V_EMPTY) {
            String message = String.format(Locale.ROOT, "[%s] is not present in the index settings for index with UUID [%s]", IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), indexSettings.get("index.uuid"));
            throw new IllegalStateException(message);
        }
        return indexVersion;
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        String[] parts;
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            if (rawMajor >= 7 && parts.length == 4) {
                throw new IllegalArgumentException("illegal version format - qualifiers are only supported until version 6.x");
            }
            int betaOffset = rawMajor < 5 ? 0 : 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    assert (rawMajor >= 5) : "major must be >= 5 but was " + major;
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a alpha build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = betaOffset + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.luceneVersion = Objects.requireNonNull(luceneVersion);
    }

    public boolean after(Version version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id <= this.id;
    }

    public boolean before(Version version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id >= this.id;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.id, other.id);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        if (this.major == 6) {
            return Version.fromId(5060099);
        }
        if (this.major >= 7) {
            Version bwcVersion = null;
            for (int i = DeclaredVersionsHolder.DECLARED_VERSIONS.size() - 1; i >= 0; --i) {
                Version candidateVersion = DeclaredVersionsHolder.DECLARED_VERSIONS.get(i);
                if (candidateVersion.major != this.major - 1 || !candidateVersion.isRelease() || !this.after(candidateVersion)) continue;
                if (bwcVersion != null && candidateVersion.minor < bwcVersion.minor) break;
                bwcVersion = candidateVersion;
            }
            return bwcVersion == null ? this : bwcVersion;
        }
        return Version.min(this, Version.fromId(this.major * 1000000 + 0 + 99));
    }

    public Version minimumIndexCompatibilityVersion() {
        int bwcMajor;
        if (this.major == 5) {
            bwcMajor = 2;
        } else {
            if (this.major == 7) {
                return V_6_0_0_beta1;
            }
            bwcMajor = this.major - 1;
        }
        boolean bwcMinor = false;
        return Version.min(this, Version.fromId(bwcMajor * 1000000 + 0 + 99));
    }

    public boolean isCompatible(Version version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        assert (!compatible || Math.max(this.major, version.major) - Math.min(this.major, version.major) <= 1);
        return compatible;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.flavor().displayName(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
        System.out.println(versionOutput);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            if (this.major >= 2) {
                sb.append("-beta");
            } else {
                sb.append(".Beta");
            }
            sb.append(this.major < 5 ? this.build : this.build - 25);
        } else if (this.build < 99) {
            if (this.major >= 2) {
                sb.append("-rc");
            } else {
                sb.append(".RC");
            }
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isBeta() {
        return this.major < 5 ? this.build < 50 : this.build >= 25 && this.build < 50;
    }

    public boolean isAlpha() {
        return this.major < 5 ? false : this.build < 25;
    }

    public boolean isRC() {
        return this.build > 50 && this.build < 99;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("V(_\\d+)+(_(alpha|beta|rc)\\d+)?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return versions;
    }

    static {
        CURRENT = V_7_8_1 = new Version(7080199, org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LUCENE_8_5_1);
        ImmutableOpenIntMap.Builder<Version> builder = ImmutableOpenIntMap.builder();
        for (Field declaredField : Version.class.getFields()) {
            String fieldName;
            if (!declaredField.getType().equals(Version.class) || (fieldName = declaredField.getName()).equals("CURRENT") || fieldName.equals("V_EMPTY")) continue;
            assert (fieldName.matches("V_\\d+_\\d+_\\d+(_alpha[1,2]|_beta[1,2]|_rc[1,2])?")) : "expected Version field [" + fieldName + "] to match V_\\d+_\\d+_\\d+";
            try {
                Version version = (Version)declaredField.get(null);
                if (Assertions.ENABLED) {
                    String[] fields = fieldName.split("_");
                    if (fields.length == 5) {
                        assert (fields[1].equals("6") && fields[2].equals("0")) : "field " + fieldName + " should not have a build qualifier";
                    } else {
                        int major = Integer.valueOf(fields[1]) * 1000000;
                        int minor = Integer.valueOf(fields[2]) * 10000;
                        int revision = Integer.valueOf(fields[3]) * 100;
                        int expectedId = major + minor + revision + 99;
                        assert (version.id == expectedId) : "expected version [" + fieldName + "] to have id [" + expectedId + "] but was [" + version.id + "]";
                    }
                }
                Version maybePrevious = builder.put(version.id, version);
                if ($assertionsDisabled || maybePrevious == null) continue;
                throw new AssertionError((Object)("expected [" + version.id + "] to be uniquely mapped but saw [" + maybePrevious + "] and [" + version + "]"));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Version field [" + fieldName + "] should be public";
            }
        }
        assert (Version.CURRENT.luceneVersion.equals(org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Version.LATEST + "] is still set to [" + Version.CURRENT.luceneVersion + "]";
        idToVersion = builder.build();
    }

    private static class DeclaredVersionsHolder {
        static final List<Version> DECLARED_VERSIONS = Collections.unmodifiableList(Version.getDeclaredVersions(Version.class));

        private DeclaredVersionsHolder() {
        }
    }
}

