/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.repositories.cleanup;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRunnable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.StepListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.SnapshotsInProgress;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.repositories.RepositoriesService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.repositories.Repository;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.repositories.RepositoryCleanupResult;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.repositories.RepositoryData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.snapshots.SnapshotsService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public final class TransportCleanupRepositoryAction
extends TransportMasterNodeAction<CleanupRepositoryRequest, CleanupRepositoryResponse> {
    private static final Logger logger = LogManager.getLogger(TransportCleanupRepositoryAction.class);
    private static final Version MIN_VERSION = Version.V_7_4_0;
    private final RepositoriesService repositoriesService;
    private final SnapshotsService snapshotsService;

    @Override
    protected String executor() {
        return "generic";
    }

    @Inject
    public TransportCleanupRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, SnapshotsService snapshotsService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/_cleanup", transportService, clusterService, threadPool, actionFilters, CleanupRepositoryRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
        this.snapshotsService = snapshotsService;
        clusterService.addStateApplier(event -> {
            if (event.localNodeMaster() && !event.previousState().nodes().isLocalNodeElectedMaster()) {
                final RepositoryCleanupInProgress repositoryCleanupInProgress = (RepositoryCleanupInProgress)event.state().custom("repository_cleanup");
                if (repositoryCleanupInProgress == null || !repositoryCleanupInProgress.hasCleanupInProgress()) {
                    return;
                }
                clusterService.submitStateUpdateTask("clean up repository cleanup task after master failover", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        logger.debug("Removed repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        logger.warn("Failed to remove repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }
                });
            }
        });
    }

    private static ClusterState removeInProgressCleanup(ClusterState currentState) {
        RepositoryCleanupInProgress cleanupInProgress = (RepositoryCleanupInProgress)currentState.custom("repository_cleanup");
        if (cleanupInProgress != null) {
            boolean changed = false;
            if (cleanupInProgress.hasCleanupInProgress()) {
                cleanupInProgress = new RepositoryCleanupInProgress(new RepositoryCleanupInProgress.Entry[0]);
                changed = true;
            }
            if (changed) {
                return ClusterState.builder(currentState).putCustom("repository_cleanup", cleanupInProgress).build();
            }
        }
        return currentState;
    }

    @Override
    protected CleanupRepositoryResponse read(StreamInput in) throws IOException {
        return new CleanupRepositoryResponse(in);
    }

    @Override
    protected void masterOperation(CleanupRepositoryRequest request, ClusterState state, ActionListener<CleanupRepositoryResponse> listener) {
        if (!state.nodes().getMinNodeVersion().onOrAfter(MIN_VERSION)) {
            throw new IllegalArgumentException("Repository cleanup is only supported from version [" + MIN_VERSION + "] but the oldest node version in the cluster is [" + state.nodes().getMinNodeVersion() + ']');
        }
        this.cleanupRepo(request.name(), ActionListener.map(listener, CleanupRepositoryResponse::new));
    }

    @Override
    protected ClusterBlockException checkBlock(CleanupRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private void cleanupRepo(final String repositoryName, final ActionListener<RepositoryCleanupResult> listener) {
        Repository repository = this.repositoriesService.repository(repositoryName);
        if (!(repository instanceof BlobStoreRepository)) {
            listener.onFailure(new IllegalArgumentException("Repository [" + repositoryName + "] does not support repository cleanup"));
            return;
        }
        final BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
        repository.getRepositoryData(repositoryDataListener);
        repositoryDataListener.whenComplete(repositoryData -> {
            final long repositoryStateId = repositoryData.getGenId();
            logger.info("Running cleanup operations on repository [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
            this.clusterService.submitStateUpdateTask("cleanup repository [" + repositoryName + "][" + repositoryStateId + ']', new ClusterStateUpdateTask((RepositoryData)repositoryData){
                private boolean startedCleanup = false;
                final /* synthetic */ RepositoryData val$repositoryData;
                {
                    this.val$repositoryData = repositoryData;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryCleanupInProgress repositoryCleanupInProgress = (RepositoryCleanupInProgress)currentState.custom("repository_cleanup");
                    if (repositoryCleanupInProgress != null && repositoryCleanupInProgress.hasCleanupInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a repository cleanup is already in-progress in [" + repositoryCleanupInProgress + "]");
                    }
                    SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                    if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently being deleted in [" + deletionsInProgress + "]");
                    }
                    SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                    if (snapshots != null && !snapshots.entries().isEmpty()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently running in [" + snapshots + "]");
                    }
                    return ClusterState.builder(currentState).putCustom("repository_cleanup", new RepositoryCleanupInProgress(RepositoryCleanupInProgress.startedEntry(repositoryName, repositoryStateId))).build();
                }

                @Override
                public void onFailure(String source, Exception e) {
                    this.after(e, null);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    this.startedCleanup = true;
                    logger.debug("Initialized repository cleanup in cluster state for [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    TransportCleanupRepositoryAction.this.threadPool.executor("snapshot").execute(ActionRunnable.wrap(listener, l -> blobStoreRepository.cleanup(repositoryStateId, TransportCleanupRepositoryAction.this.snapshotsService.minCompatibleVersion(newState.nodes().getMinNodeVersion(), repositoryName, this.val$repositoryData, null), ActionListener.wrap(result -> this.after(null, (RepositoryCleanupResult)result), e -> this.after((Exception)e, null)))));
                }

                private void after(final @Nullable Exception failure, final @Nullable RepositoryCleanupResult result) {
                    if (failure == null) {
                        logger.debug("Finished repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    } else {
                        logger.debug(() -> new ParameterizedMessage("Failed to finish repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId), (Throwable)failure);
                    }
                    assert (failure != null || result != null);
                    if (!this.startedCleanup) {
                        logger.debug("No cleanup task to remove from cluster state because we failed to start one", (Throwable)failure);
                        listener.onFailure(failure);
                        return;
                    }
                    TransportCleanupRepositoryAction.this.clusterService.submitStateUpdateTask("remove repository cleanup task [" + repositoryName + "][" + repositoryStateId + ']', new ClusterStateUpdateTask(){

                        @Override
                        public ClusterState execute(ClusterState currentState) {
                            return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                        }

                        @Override
                        public void onFailure(String source, Exception e) {
                            if (failure != null) {
                                e.addSuppressed(failure);
                            }
                            logger.warn(() -> new ParameterizedMessage("[{}] failed to remove repository cleanup task", (Object)repositoryName), (Throwable)e);
                            listener.onFailure(e);
                        }

                        @Override
                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            if (failure == null) {
                                logger.info("Done with repository cleanup on [{}][{}] with result [{}]", (Object)repositoryName, (Object)repositoryStateId, (Object)result);
                                listener.onResponse(result);
                            } else {
                                logger.warn(() -> new ParameterizedMessage("Failed to run repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId), (Throwable)failure);
                                listener.onFailure(failure);
                            }
                        }
                    });
                }
            });
        }, listener::onFailure);
    }
}

