/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class TransportCreateIndexAction
extends TransportMasterNodeAction<CreateIndexRequest, CreateIndexResponse> {
    private final MetadataCreateIndexService createIndexService;

    @Inject
    public TransportCreateIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/create", transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver);
        this.createIndexService = createIndexService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected CreateIndexResponse read(StreamInput in) throws IOException {
        return new CreateIndexResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
    }

    @Override
    protected void masterOperation(CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> listener) {
        if (request.cause().length() == 0) {
            request.cause("api");
        }
        TransportCreateIndexAction.innerCreateIndex(request, listener, this.indexNameExpressionResolver, this.createIndexService);
    }

    static void innerCreateIndex(CreateIndexRequest request, ActionListener<CreateIndexResponse> listener, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService createIndexService) {
        String indexName = indexNameExpressionResolver.resolveDateMathExpression(request.index());
        CreateIndexClusterStateUpdateRequest updateRequest = ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(request.cause(), indexName, request.index()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).settings(request.settings()).mappings(request.mappings()).aliases(request.aliases()).waitForActiveShards(request.waitForActiveShards());
        createIndexService.createIndex(updateRequest, ActionListener.map(listener, response -> new CreateIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged(), indexName)));
    }
}

