/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.datastream;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.DataStream;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Metadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Priority;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.List;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class CreateDataStreamAction
extends ActionType<AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(CreateDataStreamAction.class);
    public static final CreateDataStreamAction INSTANCE = new CreateDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/create";

    private CreateDataStreamAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, AcknowledgedResponse> {
        private final MetadataCreateIndexService metadataCreateIndexService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService metadataCreateIndexService) {
            super(CreateDataStreamAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.metadataCreateIndexService = metadataCreateIndexService;
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected AcknowledgedResponse read(StreamInput in) throws IOException {
            return new AcknowledgedResponse(in);
        }

        @Override
        protected void masterOperation(final Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
            this.clusterService.submitStateUpdateTask("create-data-stream [" + request.name + "]", new ClusterStateUpdateTask(Priority.HIGH){

                @Override
                public TimeValue timeout() {
                    return request.masterNodeTimeout();
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    return TransportAction.createDataStream(metadataCreateIndexService, currentState, request);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(new AcknowledgedResponse(true));
                }
            });
        }

        static ClusterState createDataStream(MetadataCreateIndexService metadataCreateIndexService, ClusterState currentState, Request request) throws Exception {
            if (currentState.metadata().dataStreams().containsKey(request.name)) {
                throw new IllegalArgumentException("data_stream [" + request.name + "] already exists");
            }
            MetadataCreateIndexService.validateIndexOrAliasName(request.name, (s1, s2) -> new IllegalArgumentException("data_stream [" + s1 + "] " + s2));
            if (!request.name.toLowerCase(Locale.ROOT).equals(request.name)) {
                throw new IllegalArgumentException("data_stream [" + request.name + "] must be lowercase");
            }
            if (request.name.startsWith(".")) {
                throw new IllegalArgumentException("data_stream [" + request.name + "] must not start with '.'");
            }
            String firstBackingIndexName = DataStream.getBackingIndexName(request.name, 1L);
            CreateIndexClusterStateUpdateRequest createIndexRequest = new CreateIndexClusterStateUpdateRequest("initialize_data_stream", firstBackingIndexName, firstBackingIndexName).settings(Settings.builder().put("index.hidden", true).build());
            currentState = metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexRequest, false);
            IndexMetadata firstBackingIndex = currentState.metadata().index(firstBackingIndexName);
            assert (firstBackingIndex != null);
            Metadata.Builder builder = Metadata.builder(currentState.metadata()).put(new DataStream(request.name, request.timestampFieldName, List.of(firstBackingIndex.getIndex())));
            logger.info("adding data stream [{}]", (Object)request.name);
            return ClusterState.builder(currentState).metadata(builder).build();
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String name;
        private String timestampFieldName;

        public Request(String name) {
            this.name = name;
        }

        public void setTimestampFieldName(String timestampFieldName) {
            this.timestampFieldName = timestampFieldName;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (!Strings.hasText(this.name)) {
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
            if (!Strings.hasText(this.timestampFieldName)) {
                validationException = ValidateActions.addValidationError("timestamp field name is missing", validationException);
            }
            return validationException;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.timestampFieldName = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeString(this.timestampFieldName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.name.equals(request.name) && this.timestampFieldName.equals(request.timestampFieldName);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.timestampFieldName);
        }
    }
}

