/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.AliasValidator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Metadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Template;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.UUIDs;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.compress.CompressedXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class TransportSimulateIndexTemplateAction
extends TransportMasterNodeReadAction<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private AliasValidator aliasValidator;

    @Inject
    public TransportSimulateIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService) {
        super("indices:admin/index_template/simulate_index", transportService, clusterService, threadPool, actionFilters, SimulateIndexTemplateRequest::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.aliasValidator = new AliasValidator();
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected SimulateIndexTemplateResponse read(StreamInput in) throws IOException {
        return new SimulateIndexTemplateResponse(in);
    }

    @Override
    protected void masterOperation(SimulateIndexTemplateRequest request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        String matchingTemplate;
        ClusterState simulateOnClusterState = state;
        if (request.getIndexTemplateRequest() != null) {
            String simulateTemplateToAdd = "simulate_new_template_" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
            simulateOnClusterState = this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        }
        if ((matchingTemplate = MetadataIndexTemplateService.findV2Template(simulateOnClusterState.metadata(), request.getIndexName(), false)) == null) {
            listener.onResponse(new SimulateIndexTemplateResponse(null, null));
            return;
        }
        Settings settings = MetadataIndexTemplateService.resolveSettings(simulateOnClusterState.metadata(), matchingTemplate);
        Map<String, Map<String, Object>> mappings = MetadataCreateIndexService.resolveV2Mappings("{}", simulateOnClusterState, matchingTemplate, this.xContentRegistry);
        String mappingsJson = Strings.toString(XContentFactory.jsonBuilder().startObject().field("_doc", mappings).endObject());
        List<Map<String, AliasMetadata>> resolvedAliases = MetadataIndexTemplateService.resolveAliases(simulateOnClusterState.metadata(), matchingTemplate);
        Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(settings).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata indexMetadata = IndexMetadata.builder(request.getIndexName()).settings(dummySettings).build();
        ClusterState tempClusterState = ClusterState.builder(simulateOnClusterState).metadata(Metadata.builder(simulateOnClusterState.metadata()).put(indexMetadata, true).build()).build();
        List aliases = this.indicesService.withTempIndexService(indexMetadata, tempIndexService -> MetadataCreateIndexService.resolveAndValidateAliases(request.getIndexName(), Collections.emptySet(), resolvedAliases, tempClusterState.metadata(), this.aliasValidator, this.xContentRegistry, tempIndexService.newQueryShardContext(0, null, () -> 0L, null)));
        ComposableIndexTemplate templateV2 = tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        Template template = new Template(settings, mappingsJson == null ? null : new CompressedXContent(mappingsJson), aliases.stream().collect(Collectors.toMap(AliasMetadata::getAlias, Function.identity())));
        listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

