/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.IntArrayList;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ObjectObjectHashMap;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.CollectionStatistics;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermStatistics;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopFieldDocs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchProgressListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.HppcMaps;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.DelayableWriteable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHits;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchPhaseResult;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchShardTarget;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.dfs.AggregatedDfs;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.dfs.DfsSearchResult;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.FetchSearchResult;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.InternalSearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.ProfileShardResult;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.SearchProfileShardResults;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.query.QuerySearchResult;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.Suggest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.completion.CompletionSuggestion;

public final class SearchPhaseController {
    private static final Logger logger = LogManager.getLogger(SearchPhaseController.class);
    private static final ScoreDoc[] EMPTY_DOCS = new ScoreDoc[0];
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final Function<SearchRequest, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder;

    public SearchPhaseController(NamedWriteableRegistry namedWriteableRegistry, Function<SearchRequest, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder) {
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.requestToAggReduceContextBuilder = requestToAggReduceContextBuilder;
    }

    public AggregatedDfs aggregateDfs(Collection<DfsSearchResult> results) {
        ObjectObjectHashMap<Term, TermStatistics> termStatistics = HppcMaps.newNoNullKeysMap();
        ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
        long aggMaxDoc = 0L;
        for (DfsSearchResult lEntry : results) {
            Term[] terms = lEntry.terms();
            TermStatistics[] stats = lEntry.termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                if (stats[i] == null) continue;
                TermStatistics existing = termStatistics.get(terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals(existing.term()));
                    termStatistics.put(terms[i], new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), existing.totalTermFreq() + stats[i].totalTermFreq()));
                    continue;
                }
                termStatistics.put(terms[i], stats[i]);
            }
            assert (!lEntry.fieldStatistics().containsKey(null));
            Object[] keys = lEntry.fieldStatistics().keys;
            Object[] values = lEntry.fieldStatistics().values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                String key = (String)keys[i];
                CollectionStatistics value = (CollectionStatistics)values[i];
                if (value == null) continue;
                assert (key != null);
                CollectionStatistics existing = fieldStatistics.get(key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), existing.docCount() + value.docCount(), existing.sumTotalTermFreq() + value.sumTotalTermFreq(), existing.sumDocFreq() + value.sumDocFreq());
                    fieldStatistics.put(key, merged);
                    continue;
                }
                fieldStatistics.put(key, value);
            }
            aggMaxDoc += (long)lEntry.maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }

    /*
     * WARNING - void declaration
     */
    static SortedTopDocs sortDocs(boolean ignoreFrom, Collection<? extends SearchPhaseResult> results, Collection<TopDocs> bufferedTopDocs, TopDocsStats topDocsStats, int from, int size, List<CompletionSuggestion> reducedCompletionSuggestions) {
        boolean hasHits;
        if (results.isEmpty()) {
            return SortedTopDocs.EMPTY;
        }
        ArrayList<TopDocs> topDocs = bufferedTopDocs == null ? new ArrayList<TopDocs>() : bufferedTopDocs;
        for (SearchPhaseResult searchPhaseResult : results) {
            QuerySearchResult queryResult = searchPhaseResult.queryResult();
            if (queryResult.hasConsumedTopDocs()) continue;
            TopDocsAndMaxScore td = queryResult.consumeTopDocs();
            assert (td != null);
            topDocsStats.add(td, queryResult.searchTimedOut(), queryResult.terminatedEarly());
            if (td.topDocs.scoreDocs.length <= 0) continue;
            SearchPhaseController.setShardIndex(td.topDocs, queryResult.getShardIndex());
            topDocs.add(td.topDocs);
        }
        boolean bl = hasHits = !(reducedCompletionSuggestions.isEmpty() && topDocs.isEmpty());
        if (hasHits) {
            void var14_22;
            ScoreDoc[] mergedScoreDocs;
            TopDocs topDocs2 = SearchPhaseController.mergeTopDocs(topDocs, size, ignoreFrom ? 0 : from);
            ScoreDoc[] scoreDocs = mergedScoreDocs = topDocs2 == null ? EMPTY_DOCS : topDocs2.scoreDocs;
            if (!reducedCompletionSuggestions.isEmpty()) {
                int numSuggestDocs = 0;
                for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                    assert (completionSuggestion != null);
                    numSuggestDocs += completionSuggestion.getOptions().size();
                }
                scoreDocs = new ScoreDoc[mergedScoreDocs.length + numSuggestDocs];
                System.arraycopy(mergedScoreDocs, 0, scoreDocs, 0, mergedScoreDocs.length);
                int offset = mergedScoreDocs.length;
                for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                    for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                        scoreDocs[offset++] = option.getDoc();
                    }
                }
            }
            boolean isSortedByField = false;
            SortField[] sortFields = null;
            Object var14_20 = null;
            Object[] collapseValues = null;
            if (topDocs2 instanceof TopFieldDocs) {
                TopFieldDocs fieldDocs = (TopFieldDocs)topDocs2;
                sortFields = fieldDocs.fields;
                if (fieldDocs instanceof CollapseTopFieldDocs) {
                    isSortedByField = !(fieldDocs.fields.length == 1 && fieldDocs.fields[0].getType() == SortField.Type.SCORE);
                    CollapseTopFieldDocs collapseTopFieldDocs = (CollapseTopFieldDocs)fieldDocs;
                    String string = collapseTopFieldDocs.field;
                    collapseValues = collapseTopFieldDocs.collapseValues;
                } else {
                    isSortedByField = true;
                }
            }
            return new SortedTopDocs(scoreDocs, isSortedByField, sortFields, (String)var14_22, collapseValues);
        }
        return SortedTopDocs.EMPTY;
    }

    static TopDocs mergeTopDocs(Collection<TopDocs> results, int topN, int from) {
        TopDocs mergedTopDocs;
        if (results.isEmpty()) {
            return null;
        }
        boolean setShardIndex = false;
        TopDocs topDocs = results.stream().findFirst().get();
        int numShards = results.size();
        if (numShards == 1 && from == 0) {
            return topDocs;
        }
        if (topDocs instanceof CollapseTopFieldDocs) {
            CollapseTopFieldDocs firstTopDocs = (CollapseTopFieldDocs)topDocs;
            Sort sort = new Sort(firstTopDocs.fields);
            CollapseTopFieldDocs[] shardTopDocs = results.toArray(new CollapseTopFieldDocs[numShards]);
            mergedTopDocs = CollapseTopFieldDocs.merge(sort, from, topN, shardTopDocs, false);
        } else if (topDocs instanceof TopFieldDocs) {
            TopFieldDocs firstTopDocs = (TopFieldDocs)topDocs;
            Sort sort = new Sort(firstTopDocs.fields);
            TopFieldDocs[] shardTopDocs = results.toArray(new TopFieldDocs[numShards]);
            mergedTopDocs = TopDocs.merge(sort, from, topN, shardTopDocs, false);
        } else {
            TopDocs[] shardTopDocs = results.toArray(new TopDocs[numShards]);
            mergedTopDocs = TopDocs.merge(from, topN, shardTopDocs, false);
        }
        return mergedTopDocs;
    }

    private static void setShardIndex(TopDocs topDocs, int shardIndex) {
        assert (topDocs.scoreDocs.length == 0 || topDocs.scoreDocs[0].shardIndex == -1) : "shardIndex is already set";
        for (ScoreDoc doc : topDocs.scoreDocs) {
            doc.shardIndex = shardIndex;
        }
    }

    public ScoreDoc[] getLastEmittedDocPerShard(ReducedQueryPhase reducedQueryPhase, int numShards) {
        ScoreDoc[] lastEmittedDocPerShard = new ScoreDoc[numShards];
        if (!reducedQueryPhase.isEmptyResult) {
            ScoreDoc[] sortedScoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
            long size = Math.min(reducedQueryPhase.fetchHits, (long)reducedQueryPhase.size);
            size = Math.min((long)sortedScoreDocs.length, size);
            int sortedDocsIndex = 0;
            while ((long)sortedDocsIndex < size) {
                ScoreDoc scoreDoc;
                lastEmittedDocPerShard[scoreDoc.shardIndex] = scoreDoc = sortedScoreDocs[sortedDocsIndex];
                ++sortedDocsIndex;
            }
        }
        return lastEmittedDocPerShard;
    }

    public IntArrayList[] fillDocIdsToLoad(int numShards, ScoreDoc[] shardDocs) {
        IntArrayList[] docIdsToLoad = new IntArrayList[numShards];
        for (ScoreDoc shardDoc : shardDocs) {
            IntArrayList shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex];
            if (shardDocIdsToLoad == null) {
                shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex] = new IntArrayList();
            }
            shardDocIdsToLoad.add(shardDoc.doc);
        }
        return docIdsToLoad;
    }

    public InternalSearchResponse merge(boolean ignoreFrom, ReducedQueryPhase reducedQueryPhase, Collection<? extends SearchPhaseResult> fetchResults, IntFunction<SearchPhaseResult> resultsLookup) {
        if (reducedQueryPhase.isEmptyResult) {
            return InternalSearchResponse.empty();
        }
        ScoreDoc[] sortedDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
        SearchHits hits = this.getHits(reducedQueryPhase, ignoreFrom, fetchResults, resultsLookup);
        if (reducedQueryPhase.suggest != null && !fetchResults.isEmpty()) {
            int currentOffset = hits.getHits().length;
            for (CompletionSuggestion suggestion : reducedQueryPhase.suggest.filter(CompletionSuggestion.class)) {
                List<CompletionSuggestion.Entry.Option> suggestionOptions = suggestion.getOptions();
                for (int scoreDocIndex = currentOffset; scoreDocIndex < currentOffset + suggestionOptions.size(); ++scoreDocIndex) {
                    ScoreDoc shardDoc = sortedDocs[scoreDocIndex];
                    SearchPhaseResult searchResultProvider = resultsLookup.apply(shardDoc.shardIndex);
                    if (searchResultProvider == null) continue;
                    FetchSearchResult fetchResult = searchResultProvider.fetchResult();
                    int index = fetchResult.counterGetAndIncrement();
                    assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                    SearchHit hit = fetchResult.hits().getHits()[index];
                    CompletionSuggestion.Entry.Option suggestOption = suggestionOptions.get(scoreDocIndex - currentOffset);
                    hit.score(shardDoc.score);
                    hit.shard(fetchResult.getSearchShardTarget());
                    suggestOption.setHit(hit);
                }
                currentOffset += suggestionOptions.size();
            }
            assert (currentOffset == sortedDocs.length) : "expected no more score doc slices";
        }
        return reducedQueryPhase.buildResponse(hits);
    }

    /*
     * WARNING - void declaration
     */
    private SearchHits getHits(ReducedQueryPhase reducedQueryPhase, boolean ignoreFrom, Collection<? extends SearchPhaseResult> fetchResults, IntFunction<SearchPhaseResult> resultsLookup) {
        SortedTopDocs sortedTopDocs = reducedQueryPhase.sortedTopDocs;
        int sortScoreIndex = -1;
        if (sortedTopDocs.isSortedByField) {
            void var8_10;
            SortField[] sortFields = sortedTopDocs.sortFields;
            boolean bl = false;
            while (var8_10 < sortFields.length) {
                if (((SortField)sortFields[var8_10]).getType() == SortField.Type.SCORE) {
                    sortScoreIndex = var8_10;
                }
                ++var8_10;
            }
        }
        for (SearchPhaseResult searchPhaseResult : fetchResults) {
            searchPhaseResult.fetchResult().initCounter();
        }
        int from = ignoreFrom ? 0 : reducedQueryPhase.from;
        int n2 = (int)Math.min(reducedQueryPhase.fetchHits - (long)from, (long)reducedQueryPhase.size);
        n2 = Math.min(sortedTopDocs.scoreDocs.length, n2);
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        if (!fetchResults.isEmpty()) {
            for (int i = 0; i < n2; ++i) {
                ScoreDoc shardDoc = sortedTopDocs.scoreDocs[i];
                SearchPhaseResult fetchResultProvider = resultsLookup.apply(shardDoc.shardIndex);
                if (fetchResultProvider == null) continue;
                FetchSearchResult fetchResult = fetchResultProvider.fetchResult();
                int index = fetchResult.counterGetAndIncrement();
                assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                SearchHit searchHit = fetchResult.hits().getHits()[index];
                searchHit.shard(fetchResult.getSearchShardTarget());
                if (sortedTopDocs.isSortedByField) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields, reducedQueryPhase.sortValueFormats);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                } else {
                    searchHit.score(shardDoc.score);
                }
                hits.add(searchHit);
            }
        }
        return new SearchHits(hits.toArray(new SearchHit[0]), reducedQueryPhase.totalHits, reducedQueryPhase.maxScore, sortedTopDocs.sortFields, sortedTopDocs.collapseField, sortedTopDocs.collapseValues);
    }

    ReducedQueryPhase reducedScrollQueryPhase(Collection<? extends SearchPhaseResult> queryResults) {
        InternalAggregation.ReduceContextBuilder aggReduceContextBuilder = new InternalAggregation.ReduceContextBuilder(){

            @Override
            public InternalAggregation.ReduceContext forPartialReduction() {
                throw new UnsupportedOperationException("Scroll requests don't have aggs");
            }

            @Override
            public InternalAggregation.ReduceContext forFinalReduction() {
                throw new UnsupportedOperationException("Scroll requests don't have aggs");
            }
        };
        return this.reducedQueryPhase(queryResults, true, Integer.MAX_VALUE, aggReduceContextBuilder, true);
    }

    public ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, boolean isScrollRequest, int trackTotalHitsUpTo, InternalAggregation.ReduceContextBuilder aggReduceContextBuilder, boolean performFinalReduce) {
        return this.reducedQueryPhase(queryResults, null, new ArrayList<TopDocs>(), new TopDocsStats(trackTotalHitsUpTo), 0, isScrollRequest, aggReduceContextBuilder, performFinalReduce);
    }

    private ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, List<DelayableWriteable<InternalAggregations>> bufferedAggs, List<TopDocs> bufferedTopDocs, TopDocsStats topDocsStats, int numReducePhases, boolean isScrollRequest, InternalAggregation.ReduceContextBuilder aggReduceContextBuilder, boolean performFinalReduce) {
        List<CompletionSuggestion> reducedCompletionSuggestions;
        Suggest reducedSuggest;
        List<DelayableWriteable<InternalAggregations>> aggregationsList;
        boolean consumeAggs;
        assert (numReducePhases >= 0) : "num reduce phases must be >= 0 but was: " + numReducePhases;
        ++numReducePhases;
        if (queryResults.isEmpty()) {
            TotalHits totalHits = topDocsStats.getTotalHits();
            return new ReducedQueryPhase(totalHits, topDocsStats.fetchHits, topDocsStats.getMaxScore(), false, null, null, null, null, SortedTopDocs.EMPTY, null, numReducePhases, 0, 0, true);
        }
        int total = queryResults.size();
        queryResults = queryResults.stream().filter(res -> !res.queryResult().isNull()).collect(Collectors.toList());
        String errorMsg = "must have at least one non-empty search result, got 0 out of " + total;
        assert (!queryResults.isEmpty()) : errorMsg;
        if (queryResults.isEmpty()) {
            throw new IllegalStateException(errorMsg);
        }
        QuerySearchResult firstResult = ((SearchPhaseResult)queryResults.stream().findFirst().get()).queryResult();
        boolean hasSuggest = firstResult.suggest() != null;
        boolean hasProfileResults = firstResult.hasProfileResults();
        if (bufferedAggs != null) {
            consumeAggs = false;
            assert (firstResult.hasAggs()) : "firstResult has no aggs but we got non null buffered aggs?";
            aggregationsList = bufferedAggs;
        } else if (firstResult.hasAggs()) {
            aggregationsList = new ArrayList(queryResults.size());
            consumeAggs = true;
        } else {
            aggregationsList = Collections.emptyList();
            consumeAggs = false;
        }
        HashMap<String, List<Suggest.Suggestion>> groupedSuggestions = hasSuggest ? new HashMap<String, List<Suggest.Suggestion>>() : Collections.emptyMap();
        HashMap<String, ProfileShardResult> profileResults = hasProfileResults ? new HashMap<String, ProfileShardResult>(queryResults.size()) : Collections.emptyMap();
        int from = 0;
        int size = 0;
        for (SearchPhaseResult entry : queryResults) {
            QuerySearchResult result = entry.queryResult();
            from = result.from();
            size = Math.max(result.size(), size);
            if (hasSuggest) {
                assert (result.suggest() != null);
                for (Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion : result.suggest()) {
                    List suggestionList = groupedSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList());
                    suggestionList.add(suggestion);
                    if (!(suggestion instanceof CompletionSuggestion)) continue;
                    CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggestion;
                    completionSuggestion.setShardIndex(result.getShardIndex());
                }
            }
            if (consumeAggs) {
                aggregationsList.add(result.consumeAggs());
            }
            if (!hasProfileResults) continue;
            String key = result.getSearchShardTarget().toString();
            profileResults.put(key, result.consumeProfileResult());
        }
        if (groupedSuggestions.isEmpty()) {
            reducedSuggest = null;
            reducedCompletionSuggestions = Collections.emptyList();
        } else {
            reducedSuggest = new Suggest(Suggest.reduce(groupedSuggestions));
            reducedCompletionSuggestions = reducedSuggest.filter(CompletionSuggestion.class);
        }
        InternalAggregations aggregations = SearchPhaseController.reduceAggs(aggReduceContextBuilder, performFinalReduce, aggregationsList);
        SearchProfileShardResults shardResults = profileResults.isEmpty() ? null : new SearchProfileShardResults(profileResults);
        SortedTopDocs sortedTopDocs = SearchPhaseController.sortDocs(isScrollRequest, queryResults, bufferedTopDocs, topDocsStats, from, size, reducedCompletionSuggestions);
        TotalHits totalHits = topDocsStats.getTotalHits();
        return new ReducedQueryPhase(totalHits, topDocsStats.fetchHits, topDocsStats.getMaxScore(), topDocsStats.timedOut, topDocsStats.terminatedEarly, reducedSuggest, aggregations, shardResults, sortedTopDocs, firstResult.sortValueFormats(), numReducePhases, size, from, false);
    }

    private static InternalAggregations reduceAggs(InternalAggregation.ReduceContextBuilder aggReduceContextBuilder, boolean performFinalReduce, List<DelayableWriteable<InternalAggregations>> aggregationsList) {
        ArrayList<InternalAggregations> toReduce = new ArrayList<InternalAggregations>(aggregationsList.size());
        for (int i = 0; i < aggregationsList.size(); ++i) {
            toReduce.add(aggregationsList.get(i).expand());
            aggregationsList.set(i, null);
        }
        return aggregationsList.isEmpty() ? null : InternalAggregations.topLevelReduce(toReduce, performFinalReduce ? aggReduceContextBuilder.forFinalReduction() : aggReduceContextBuilder.forPartialReduction());
    }

    static int getTopDocsSize(SearchRequest request) {
        if (request.source() == null) {
            return 10;
        }
        SearchSourceBuilder source = request.source();
        return (source.size() == -1 ? 10 : source.size()) + (source.from() == -1 ? 0 : source.from());
    }

    ArraySearchPhaseResults<SearchPhaseResult> newSearchPhaseResults(final SearchProgressListener listener, final SearchRequest request, int numShards) {
        SearchSourceBuilder source = request.source();
        final boolean isScrollRequest = request.scroll() != null;
        boolean hasAggs = source != null && source.aggregations() != null;
        boolean hasTopDocs = source == null || source.size() != 0;
        final int trackTotalHitsUpTo = request.resolveTrackTotalHitsUpTo();
        final InternalAggregation.ReduceContextBuilder aggReduceContextBuilder = this.requestToAggReduceContextBuilder.apply(request);
        if (!isScrollRequest && (hasAggs || hasTopDocs) && request.getBatchedReduceSize() < numShards) {
            int topNSize = SearchPhaseController.getTopDocsSize(request);
            return new QueryPhaseResultConsumer(this.namedWriteableRegistry, listener, this, numShards, request.getBatchedReduceSize(), hasTopDocs, hasAggs, trackTotalHitsUpTo, topNSize, aggReduceContextBuilder, request.isFinalReduce());
        }
        return new ArraySearchPhaseResults<SearchPhaseResult>(numShards){

            @Override
            void consumeResult(SearchPhaseResult result) {
                super.consumeResult(result);
                listener.notifyQueryResult(result.queryResult().getShardIndex());
            }

            @Override
            ReducedQueryPhase reduce() {
                List resultList = this.results.asList();
                ReducedQueryPhase reducePhase = SearchPhaseController.this.reducedQueryPhase(resultList, isScrollRequest, trackTotalHitsUpTo, aggReduceContextBuilder, request.isFinalReduce());
                listener.notifyFinalReduce(SearchProgressListener.buildSearchShards(resultList), reducePhase.totalHits, reducePhase.aggregations, reducePhase.numReducePhases);
                return reducePhase;
            }
        };
    }

    static /* synthetic */ ScoreDoc[] access$400() {
        return EMPTY_DOCS;
    }

    static final class TopDocsStats {
        final int trackTotalHitsUpTo;
        long totalHits;
        private TotalHits.Relation totalHitsRelation;
        long fetchHits;
        private float maxScore = Float.NEGATIVE_INFINITY;
        boolean timedOut;
        Boolean terminatedEarly;

        TopDocsStats(int trackTotalHitsUpTo) {
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            this.totalHits = 0L;
            this.totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        }

        float getMaxScore() {
            return Float.isInfinite(this.maxScore) ? Float.NaN : this.maxScore;
        }

        TotalHits getTotalHits() {
            if (this.trackTotalHitsUpTo == -1) {
                return null;
            }
            if (this.trackTotalHitsUpTo == Integer.MAX_VALUE) {
                assert (this.totalHitsRelation == TotalHits.Relation.EQUAL_TO);
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            if (this.totalHits <= (long)this.trackTotalHitsUpTo) {
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            return new TotalHits(this.trackTotalHitsUpTo, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
        }

        void add(TopDocsAndMaxScore topDocs, boolean timedOut, Boolean terminatedEarly) {
            if (this.trackTotalHitsUpTo != -1) {
                this.totalHits += topDocs.topDocs.totalHits.value;
                if (topDocs.topDocs.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                    this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                }
            }
            this.fetchHits += (long)topDocs.topDocs.scoreDocs.length;
            if (!Float.isNaN(topDocs.maxScore)) {
                this.maxScore = Math.max(this.maxScore, topDocs.maxScore);
            }
            if (timedOut) {
                this.timedOut = true;
            }
            if (terminatedEarly != null) {
                if (this.terminatedEarly == null) {
                    this.terminatedEarly = terminatedEarly;
                } else if (terminatedEarly.booleanValue()) {
                    this.terminatedEarly = true;
                }
            }
        }
    }

    public static final class ReducedQueryPhase {
        final TotalHits totalHits;
        final long fetchHits;
        final float maxScore;
        final boolean timedOut;
        final Boolean terminatedEarly;
        final Suggest suggest;
        final InternalAggregations aggregations;
        final SearchProfileShardResults shardResults;
        final int numReducePhases;
        final SortedTopDocs sortedTopDocs;
        final int size;
        final boolean isEmptyResult;
        final int from;
        final DocValueFormat[] sortValueFormats;

        ReducedQueryPhase(TotalHits totalHits, long fetchHits, float maxScore, boolean timedOut, Boolean terminatedEarly, Suggest suggest, InternalAggregations aggregations, SearchProfileShardResults shardResults, SortedTopDocs sortedTopDocs, DocValueFormat[] sortValueFormats, int numReducePhases, int size, int from, boolean isEmptyResult) {
            if (numReducePhases <= 0) {
                throw new IllegalArgumentException("at least one reduce phase must have been applied but was: " + numReducePhases);
            }
            this.totalHits = totalHits;
            this.fetchHits = fetchHits;
            this.maxScore = maxScore;
            this.timedOut = timedOut;
            this.terminatedEarly = terminatedEarly;
            this.suggest = suggest;
            this.aggregations = aggregations;
            this.shardResults = shardResults;
            this.numReducePhases = numReducePhases;
            this.sortedTopDocs = sortedTopDocs;
            this.size = size;
            this.from = from;
            this.isEmptyResult = isEmptyResult;
            this.sortValueFormats = sortValueFormats;
        }

        public InternalSearchResponse buildResponse(SearchHits hits) {
            return new InternalSearchResponse(hits, this.aggregations, this.suggest, this.shardResults, this.timedOut, this.terminatedEarly, this.numReducePhases);
        }
    }

    static final class SortedTopDocs {
        static final SortedTopDocs EMPTY = new SortedTopDocs(SearchPhaseController.access$400(), false, null, null, null);
        final ScoreDoc[] scoreDocs;
        final boolean isSortedByField;
        final SortField[] sortFields;
        final String collapseField;
        final Object[] collapseValues;

        SortedTopDocs(ScoreDoc[] scoreDocs, boolean isSortedByField, SortField[] sortFields, String collapseField, Object[] collapseValues) {
            this.scoreDocs = scoreDocs;
            this.isSortedByField = isSortedByField;
            this.sortFields = sortFields;
            this.collapseField = collapseField;
            this.collapseValues = collapseValues;
        }
    }

    static final class QueryPhaseResultConsumer
    extends ArraySearchPhaseResults<SearchPhaseResult> {
        private final NamedWriteableRegistry namedWriteableRegistry;
        private final SearchShardTarget[] processedShards;
        private final DelayableWriteable.Serialized<InternalAggregations>[] aggsBuffer;
        private final TopDocs[] topDocsBuffer;
        private final boolean hasAggs;
        private final boolean hasTopDocs;
        private final int bufferSize;
        private int index;
        private final SearchPhaseController controller;
        private final SearchProgressListener progressListener;
        private int numReducePhases = 0;
        private final TopDocsStats topDocsStats;
        private final int topNSize;
        private final InternalAggregation.ReduceContextBuilder aggReduceContextBuilder;
        private final boolean performFinalReduce;
        private long aggsCurrentBufferSize;
        private long aggsMaxBufferSize;

        private QueryPhaseResultConsumer(NamedWriteableRegistry namedWriteableRegistry, SearchProgressListener progressListener, SearchPhaseController controller, int expectedResultSize, int bufferSize, boolean hasTopDocs, boolean hasAggs, int trackTotalHitsUpTo, int topNSize, InternalAggregation.ReduceContextBuilder aggReduceContextBuilder, boolean performFinalReduce) {
            super(expectedResultSize);
            this.namedWriteableRegistry = namedWriteableRegistry;
            if (expectedResultSize != 1 && bufferSize < 2) {
                throw new IllegalArgumentException("buffer size must be >= 2 if there is more than one expected result");
            }
            if (expectedResultSize <= bufferSize) {
                throw new IllegalArgumentException("buffer size must be less than the expected result size");
            }
            if (!hasAggs && !hasTopDocs) {
                throw new IllegalArgumentException("either aggs or top docs must be present");
            }
            this.controller = controller;
            this.progressListener = progressListener;
            this.processedShards = new SearchShardTarget[expectedResultSize];
            DelayableWriteable.Serialized[] aggsBuffer = new DelayableWriteable.Serialized[hasAggs ? bufferSize : 0];
            this.aggsBuffer = aggsBuffer;
            this.topDocsBuffer = new TopDocs[hasTopDocs ? bufferSize : 0];
            this.hasTopDocs = hasTopDocs;
            this.hasAggs = hasAggs;
            this.bufferSize = bufferSize;
            this.topDocsStats = new TopDocsStats(trackTotalHitsUpTo);
            this.topNSize = topNSize;
            this.aggReduceContextBuilder = aggReduceContextBuilder;
            this.performFinalReduce = performFinalReduce;
        }

        @Override
        public void consumeResult(SearchPhaseResult result) {
            super.consumeResult(result);
            QuerySearchResult queryResult = result.queryResult();
            this.consumeInternal(queryResult);
            this.progressListener.notifyQueryResult(queryResult.getShardIndex());
        }

        private synchronized void consumeInternal(QuerySearchResult querySearchResult) {
            if (!querySearchResult.isNull()) {
                if (this.index == this.bufferSize) {
                    DelayableWriteable.Serialized<InternalAggregations> reducedAggs = null;
                    if (this.hasAggs) {
                        ArrayList<InternalAggregations> aggs = new ArrayList<InternalAggregations>(this.aggsBuffer.length);
                        for (int i = 0; i < this.aggsBuffer.length; ++i) {
                            aggs.add(this.aggsBuffer[i].expand());
                            this.aggsBuffer[i] = null;
                        }
                        InternalAggregations reduced = InternalAggregations.topLevelReduce(aggs, this.aggReduceContextBuilder.forPartialReduction());
                        this.aggsBuffer[0] = DelayableWriteable.referencing(reduced).asSerialized(InternalAggregations::new, this.namedWriteableRegistry);
                        reducedAggs = this.aggsBuffer[0];
                        long previousBufferSize = this.aggsCurrentBufferSize;
                        this.aggsMaxBufferSize = Math.max(this.aggsMaxBufferSize, this.aggsCurrentBufferSize);
                        this.aggsCurrentBufferSize = this.aggsBuffer[0].ramBytesUsed();
                        logger.trace("aggs partial reduction [{}->{}] max [{}]", (Object)previousBufferSize, (Object)this.aggsCurrentBufferSize, (Object)this.aggsMaxBufferSize);
                    }
                    if (this.hasTopDocs) {
                        TopDocs reducedTopDocs = SearchPhaseController.mergeTopDocs(Arrays.asList(this.topDocsBuffer), this.topNSize, 0);
                        Arrays.fill(this.topDocsBuffer, null);
                        this.topDocsBuffer[0] = reducedTopDocs;
                    }
                    ++this.numReducePhases;
                    this.index = 1;
                    if (this.hasAggs || this.hasTopDocs) {
                        this.progressListener.notifyPartialReduce(SearchProgressListener.buildSearchShards(this.processedShards), this.topDocsStats.getTotalHits(), reducedAggs, this.numReducePhases);
                    }
                }
                int i = this.index++;
                if (this.hasAggs) {
                    this.aggsBuffer[i] = querySearchResult.consumeAggs().asSerialized(InternalAggregations::new, this.namedWriteableRegistry);
                    this.aggsCurrentBufferSize += this.aggsBuffer[i].ramBytesUsed();
                }
                if (this.hasTopDocs) {
                    TopDocsAndMaxScore topDocs = querySearchResult.consumeTopDocs();
                    this.topDocsStats.add(topDocs, querySearchResult.searchTimedOut(), querySearchResult.terminatedEarly());
                    SearchPhaseController.setShardIndex(topDocs.topDocs, querySearchResult.getShardIndex());
                    this.topDocsBuffer[i] = topDocs.topDocs;
                }
            }
            this.processedShards[querySearchResult.getShardIndex()] = querySearchResult.getSearchShardTarget();
        }

        private synchronized List<DelayableWriteable<InternalAggregations>> getRemainingAggs() {
            return this.hasAggs ? Arrays.asList((DelayableWriteable[])this.aggsBuffer).subList(0, this.index) : null;
        }

        private synchronized List<TopDocs> getRemainingTopDocs() {
            return this.hasTopDocs ? Arrays.asList(this.topDocsBuffer).subList(0, this.index) : null;
        }

        @Override
        public ReducedQueryPhase reduce() {
            this.aggsMaxBufferSize = Math.max(this.aggsMaxBufferSize, this.aggsCurrentBufferSize);
            logger.trace("aggs final reduction [{}] max [{}]", (Object)this.aggsCurrentBufferSize, (Object)this.aggsMaxBufferSize);
            ReducedQueryPhase reducePhase = this.controller.reducedQueryPhase(this.results.asList(), this.getRemainingAggs(), this.getRemainingTopDocs(), this.topDocsStats, this.numReducePhases, false, this.aggReduceContextBuilder, this.performFinalReduce);
            this.progressListener.notifyFinalReduce(SearchProgressListener.buildSearchShards(this.results.asList()), reducePhase.totalHits, reducePhase.aggregations, reducePhase.numReducePhases);
            return reducePhase;
        }

        int getNumBuffered() {
            return this.index;
        }

        int getNumReducePhases() {
            return this.numReducePhases;
        }
    }
}

