/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.single.instance;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;

public abstract class InstanceShardOperationRequest<Request extends InstanceShardOperationRequest<Request>>
extends ActionRequest
implements IndicesRequest {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    protected ShardId shardId = null;
    private String concreteIndex;

    protected InstanceShardOperationRequest() {
    }

    protected InstanceShardOperationRequest(StreamInput in) throws IOException {
        super(in);
        this.index = in.readString();
        this.shardId = in.readBoolean() ? new ShardId(in) : null;
        this.timeout = in.readTimeValue();
        this.concreteIndex = in.readOptionalString();
    }

    public InstanceShardOperationRequest(String index) {
        this.index = index;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout"));
    }

    public String concreteIndex() {
        return this.concreteIndex;
    }

    void concreteIndex(String concreteIndex) {
        this.concreteIndex = concreteIndex;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeOptionalWriteable(this.shardId);
        out.writeTimeValue(this.timeout);
        out.writeOptionalString(this.concreteIndex);
    }
}

