/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestConverters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup.DeleteRollupJobRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup.GetRollupCapsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup.GetRollupIndexCapsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup.GetRollupJobRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup.PutRollupJobRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup.StartRollupJobRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup.StopRollupJobRequest;

final class RollupRequestConverters {
    private RollupRequestConverters() {
    }

    static Request putJob(PutRollupJobRequest putRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(putRollupJobRequest.getConfig().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putRollupJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request startJob(StartRollupJobRequest startRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(startRollupJobRequest.getJobId()).addPathPartAsIs("_start").build();
        return new Request("POST", endpoint);
    }

    static Request stopJob(StopRollupJobRequest stopRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(stopRollupJobRequest.getJobId()).addPathPartAsIs("_stop").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(stopRollupJobRequest.timeout());
        if (stopRollupJobRequest.waitForCompletion() != null) {
            parameters.withWaitForCompletion(stopRollupJobRequest.waitForCompletion());
        }
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request getJob(GetRollupJobRequest getRollupJobRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(getRollupJobRequest.getJobId()).build();
        return new Request("GET", endpoint);
    }

    static Request deleteJob(DeleteRollupJobRequest deleteRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(deleteRollupJobRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        request.setEntity(RequestConverters.createEntity(deleteRollupJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request search(SearchRequest request) throws IOException {
        if (request.types().length > 0) {
            ValidationException ve = new ValidationException();
            ve.addValidationError("types are not allowed in rollup search");
            throw ve;
        }
        return RequestConverters.search(request, "_rollup_search");
    }

    static Request getRollupCaps(GetRollupCapsRequest getRollupCapsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "data").addPathPart(getRollupCapsRequest.getIndexPattern()).build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getRollupCapsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getRollupIndexCaps(GetRollupIndexCapsRequest getRollupIndexCapsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(getRollupIndexCapsRequest.indices()).addPathPartAsIs("_rollup", "data").build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getRollupIndexCapsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }
}

