/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.eql;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.searchafter.SearchAfterBuilder;

public class EqlSearchRequest
implements Validatable,
ToXContentObject {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, false);
    private QueryBuilder filter = null;
    private String timestampField = "@timestamp";
    private String eventCategoryField = "event.category";
    private String implicitJoinKeyField = "agent.id";
    private int fetchSize = 50;
    private SearchAfterBuilder searchAfterBuilder;
    private String query;
    static final String KEY_FILTER = "filter";
    static final String KEY_TIMESTAMP_FIELD = "timestamp_field";
    static final String KEY_EVENT_CATEGORY_FIELD = "event_category_field";
    static final String KEY_IMPLICIT_JOIN_KEY_FIELD = "implicit_join_key_field";
    static final String KEY_SIZE = "size";
    static final String KEY_SEARCH_AFTER = "search_after";
    static final String KEY_QUERY = "query";

    public EqlSearchRequest(String indices, String query) {
        this.indices(indices);
        this.query(query);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.filter != null) {
            builder.field(KEY_FILTER, this.filter);
        }
        builder.field(KEY_TIMESTAMP_FIELD, this.timestampField());
        builder.field(KEY_EVENT_CATEGORY_FIELD, this.eventCategoryField());
        if (this.implicitJoinKeyField != null) {
            builder.field(KEY_IMPLICIT_JOIN_KEY_FIELD, this.implicitJoinKeyField());
        }
        builder.field(KEY_SIZE, this.fetchSize());
        if (this.searchAfterBuilder != null) {
            builder.array(KEY_SEARCH_AFTER, this.searchAfterBuilder.getSortValues());
        }
        builder.field(KEY_QUERY, this.query);
        builder.endObject();
        return builder;
    }

    public EqlSearchRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
        this.indices = indices;
        return this;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public EqlSearchRequest filter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public String timestampField() {
        return this.timestampField;
    }

    public EqlSearchRequest timestampField(String timestampField) {
        Objects.requireNonNull(timestampField, "timestamp field must not be null");
        this.timestampField = timestampField;
        return this;
    }

    public String eventCategoryField() {
        return this.eventCategoryField;
    }

    public EqlSearchRequest eventCategoryField(String eventCategoryField) {
        Objects.requireNonNull(eventCategoryField, "event category field must not be null");
        this.eventCategoryField = eventCategoryField;
        return this;
    }

    public String implicitJoinKeyField() {
        return this.implicitJoinKeyField;
    }

    public EqlSearchRequest implicitJoinKeyField(String implicitJoinKeyField) {
        Objects.requireNonNull(implicitJoinKeyField, "implicit join key must not be null");
        this.implicitJoinKeyField = implicitJoinKeyField;
        return this;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public EqlSearchRequest fetchSize(int size) {
        this.fetchSize = size;
        if (this.fetchSize <= 0) {
            throw new IllegalArgumentException("size must be greater than 0");
        }
        return this;
    }

    public Object[] searchAfter() {
        if (this.searchAfterBuilder == null) {
            return null;
        }
        return this.searchAfterBuilder.getSortValues();
    }

    public EqlSearchRequest searchAfter(Object[] values) {
        this.searchAfterBuilder = new SearchAfterBuilder().setSortValues(values);
        return this;
    }

    private EqlSearchRequest setSearchAfter(SearchAfterBuilder builder) {
        this.searchAfterBuilder = builder;
        return this;
    }

    public String query() {
        return this.query;
    }

    public EqlSearchRequest query(String query) {
        Objects.requireNonNull(query, "query must not be null");
        this.query = query;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqlSearchRequest that = (EqlSearchRequest)o;
        return this.fetchSize == that.fetchSize && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.filter, that.filter) && Objects.equals(this.timestampField, that.timestampField) && Objects.equals(this.eventCategoryField, that.eventCategoryField) && Objects.equals(this.implicitJoinKeyField, that.implicitJoinKeyField) && Objects.equals(this.searchAfterBuilder, that.searchAfterBuilder) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions, this.filter, this.fetchSize, this.timestampField, this.eventCategoryField, this.implicitJoinKeyField, this.searchAfterBuilder, this.query);
    }

    public String[] indices() {
        return Arrays.copyOf(this.indices, this.indices.length);
    }

    public EqlSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }
}

