/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.core.PageParams;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;

public class GetTrainedModelsRequest
implements Validatable {
    public static final String ALLOW_NO_MATCH = "allow_no_match";
    public static final String INCLUDE_MODEL_DEFINITION = "include_model_definition";
    public static final String DECOMPRESS_DEFINITION = "decompress_definition";
    public static final String TAGS = "tags";
    private final List<String> ids;
    private Boolean allowNoMatch;
    private Boolean includeDefinition;
    private Boolean decompressDefinition;
    private PageParams pageParams;
    private List<String> tags;

    public static GetTrainedModelsRequest getAllTrainedModelConfigsRequest() {
        return new GetTrainedModelsRequest("_all");
    }

    public GetTrainedModelsRequest(String ... ids) {
        this.ids = Arrays.asList(ids);
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public GetTrainedModelsRequest setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
        return this;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public GetTrainedModelsRequest setPageParams(@Nullable PageParams pageParams) {
        this.pageParams = pageParams;
        return this;
    }

    public Boolean getIncludeDefinition() {
        return this.includeDefinition;
    }

    public GetTrainedModelsRequest setIncludeDefinition(Boolean includeDefinition) {
        this.includeDefinition = includeDefinition;
        return this;
    }

    public Boolean getDecompressDefinition() {
        return this.decompressDefinition;
    }

    public GetTrainedModelsRequest setDecompressDefinition(Boolean decompressDefinition) {
        this.decompressDefinition = decompressDefinition;
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public GetTrainedModelsRequest setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public GetTrainedModelsRequest setTags(String ... tags) {
        return this.setTags(Arrays.asList(tags));
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.ids == null || this.ids.isEmpty()) {
            return Optional.of(ValidationException.withError("trained model id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTrainedModelsRequest other = (GetTrainedModelsRequest)o;
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.allowNoMatch, other.allowNoMatch) && Objects.equals(this.decompressDefinition, other.decompressDefinition) && Objects.equals(this.includeDefinition, other.includeDefinition) && Objects.equals(this.pageParams, other.pageParams);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.allowNoMatch, this.pageParams, this.decompressDefinition, this.includeDefinition);
    }
}

