/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.stats.common;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.common.TimeUtil;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class MemoryUsage
implements ToXContentObject {
    static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    static final ParseField PEAK_USAGE_BYTES = new ParseField("peak_usage_bytes", new String[0]);
    public static final ConstructingObjectParser<MemoryUsage, Void> PARSER = new ConstructingObjectParser("analytics_memory_usage", true, a -> new MemoryUsage((Instant)a[0], (Long)a[1]));
    @Nullable
    private final Instant timestamp;
    private final long peakUsageBytes;

    public MemoryUsage(@Nullable Instant timestamp, long peakUsageBytes) {
        this.timestamp = timestamp == null ? null : Instant.ofEpochMilli(Objects.requireNonNull(timestamp).toEpochMilli());
        this.peakUsageBytes = peakUsageBytes;
    }

    @Nullable
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getPeakUsageBytes() {
        return this.peakUsageBytes;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.timestamp != null) {
            builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        }
        builder.field(PEAK_USAGE_BYTES.getPreferredName(), this.peakUsageBytes);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryUsage other = (MemoryUsage)o;
        return Objects.equals(this.timestamp, other.timestamp) && this.peakUsageBytes == other.peakUsageBytes;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.peakUsageBytes);
    }

    public String toString() {
        return new ToStringBuilder(this.getClass()).add(TIMESTAMP.getPreferredName(), this.timestamp == null ? null : Long.valueOf(this.timestamp.getEpochSecond())).add(PEAK_USAGE_BYTES.getPreferredName(), this.peakUsageBytes).toString();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PEAK_USAGE_BYTES);
    }
}

