/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class TrainedModelStats
implements ToXContentObject {
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField PIPELINE_COUNT = new ParseField("pipeline_count", new String[0]);
    public static final ParseField INGEST_STATS = new ParseField("ingest", new String[0]);
    private final String modelId;
    private final Map<String, Object> ingestStats;
    private final int pipelineCount;
    static final ConstructingObjectParser<TrainedModelStats, Void> PARSER = new ConstructingObjectParser("trained_model_stats", true, args -> new TrainedModelStats((String)args[0], (Map)args[1], (Integer)args[2]));

    public static TrainedModelStats fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public TrainedModelStats(String modelId, Map<String, Object> ingestStats, int pipelineCount) {
        this.modelId = modelId;
        this.ingestStats = ingestStats;
        this.pipelineCount = pipelineCount;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Nullable
    public Map<String, Object> getIngestStats() {
        return this.ingestStats;
    }

    public int getPipelineCount() {
        return this.pipelineCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        builder.field(PIPELINE_COUNT.getPreferredName(), this.pipelineCount);
        if (this.ingestStats != null) {
            builder.field(INGEST_STATS.getPreferredName(), this.ingestStats);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.ingestStats, this.pipelineCount);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrainedModelStats other = (TrainedModelStats)obj;
        return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.ingestStats, other.ingestStats) && Objects.equals(this.pipelineCount, other.pipelineCount);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_ID);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), INGEST_STATS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), PIPELINE_COUNT);
    }
}

