/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.TransportActionNodeProxy;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.transport.TransportClientNodesService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

final class TransportProxyClient {
    private final TransportClientNodesService nodesService;
    private final Map<ActionType, TransportActionNodeProxy> proxies;

    TransportProxyClient(Settings settings, TransportService transportService, TransportClientNodesService nodesService, List<ActionType> actions) {
        this.nodesService = nodesService;
        HashMap proxies = new HashMap();
        for (ActionType action : actions) {
            proxies.put(action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.proxies = Collections.unmodifiableMap(proxies);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response>> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        TransportActionNodeProxy proxy = this.proxies.get(action);
        assert (proxy != null) : "no proxy found for action: " + action;
        this.nodesService.execute((n, l) -> proxy.execute(n, request, l), listener);
    }
}

