/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MappingMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Metadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Priority;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.compress.CompressedXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io.IOUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.Index;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.DocumentMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.IndexShard;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.InvalidTypeNameException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class MetadataMappingService {
    private static final Logger logger = LogManager.getLogger(MetadataMappingService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    final RefreshTaskExecutor refreshExecutor = new RefreshTaskExecutor();
    final PutMappingExecutor putMappingExecutor = new PutMappingExecutor();

    @Inject
    public MetadataMappingService(ClusterService clusterService, IndicesService indicesService) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState executeRefresh(ClusterState currentState, List<RefreshTask> allTasks) throws Exception {
        HashMap<String, List> tasksPerIndex = new HashMap<String, List>();
        for (RefreshTask task : allTasks) {
            if (task.index == null) {
                logger.debug("ignoring a mapping task of type [{}] with a null index.", (Object)task);
            }
            tasksPerIndex.computeIfAbsent(task.index, k -> new ArrayList()).add(task);
        }
        boolean dirty = false;
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        for (Map.Entry entry : tasksPerIndex.entrySet()) {
            IndexMetadata indexMetadata = mdBuilder.get((String)entry.getKey());
            if (indexMetadata == null) {
                logger.debug("[{}] ignoring tasks - index meta data doesn't exist", entry.getKey());
                continue;
            }
            Index index = indexMetadata.getIndex();
            List allIndexTasks = (List)entry.getValue();
            boolean hasTaskWithRightUUID = false;
            for (RefreshTask task : allIndexTasks) {
                if (indexMetadata.isSameUUID(task.indexUUID)) {
                    hasTaskWithRightUUID = true;
                    continue;
                }
                logger.debug("{} ignoring task [{}] - index meta data doesn't match task uuid", (Object)index, (Object)task);
            }
            if (!hasTaskWithRightUUID) continue;
            boolean removeIndex = false;
            IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = this.indicesService.indexService(indexMetadata.getIndex());
            if (indexService == null) {
                indexService = this.indicesService.createIndex(indexMetadata, Collections.emptyList(), false);
                removeIndex = true;
                ((IndexService)indexService).mapperService().merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            }
            IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
            try {
                boolean indexDirty = this.refreshIndexMapping((IndexService)indexService, builder);
                if (!indexDirty) continue;
                mdBuilder.put(builder);
                dirty = true;
            }
            finally {
                if (!removeIndex) continue;
                this.indicesService.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for mapping processing");
            }
        }
        if (!dirty) {
            return currentState;
        }
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    private boolean refreshIndexMapping(IndexService indexService, IndexMetadata.Builder builder) {
        boolean dirty = false;
        String index = indexService.index().getName();
        try {
            ArrayList<String> updatedTypes = new ArrayList<String>();
            MapperService mapperService = indexService.mapperService();
            for (DocumentMapper mapper : Arrays.asList(mapperService.documentMapper(), mapperService.documentMapper("_default_"))) {
                if (mapper == null) continue;
                String type = mapper.type();
                if (mapper.mappingSource().equals(builder.mapping(type).source())) continue;
                updatedTypes.add(type);
            }
            if (!updatedTypes.isEmpty()) {
                logger.warn("[{}] re-syncing mappings with cluster state because of types [{}]", (Object)index, updatedTypes);
                dirty = true;
                for (DocumentMapper mapper : Arrays.asList(mapperService.documentMapper(), mapperService.documentMapper("_default_"))) {
                    if (mapper == null) continue;
                    builder.putMapping(new MappingMetadata(mapper));
                }
            }
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to refresh-mapping in cluster state", (Object)index), (Throwable)e);
        }
        return dirty;
    }

    public void refreshMapping(String index, String indexUUID) {
        RefreshTask refreshTask = new RefreshTask(index, indexUUID);
        this.clusterService.submitStateUpdateTask("refresh-mapping", refreshTask, ClusterStateTaskConfig.build(Priority.HIGH), this.refreshExecutor, (source, e) -> logger.warn(() -> new ParameterizedMessage("failure during [{}]", (Object)source), (Throwable)e));
    }

    public void putMapping(final PutMappingClusterStateUpdateRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("put-mapping " + Strings.arrayToCommaDelimitedString(request.indices()), request, ClusterStateTaskConfig.build(Priority.HIGH, request.masterNodeTimeout()), this.putMappingExecutor, new AckedClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                listener.onResponse(new ClusterStateUpdateResponse(e == null));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterStateUpdateResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }
        });
    }

    class RefreshTaskExecutor
    implements ClusterStateTaskExecutor<RefreshTask> {
        RefreshTaskExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<RefreshTask> execute(ClusterState currentState, List<RefreshTask> tasks) throws Exception {
            ClusterState newClusterState = MetadataMappingService.this.executeRefresh(currentState, tasks);
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(newClusterState);
        }
    }

    class PutMappingExecutor
    implements ClusterStateTaskExecutor<PutMappingClusterStateUpdateRequest> {
        PutMappingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<PutMappingClusterStateUpdateRequest> execute(ClusterState currentState, List<PutMappingClusterStateUpdateRequest> tasks) throws Exception {
            HashMap<Index, MapperService> indexMapperServices = new HashMap<Index, MapperService>();
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<PutMappingClusterStateUpdateRequest> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            try {
                for (PutMappingClusterStateUpdateRequest request : tasks) {
                    try {
                        for (Index index : request.indices()) {
                            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
                            if (indexMapperServices.containsKey(indexMetadata.getIndex())) continue;
                            MapperService mapperService = MetadataMappingService.this.indicesService.createIndexMapperService(indexMetadata);
                            indexMapperServices.put(index, mapperService);
                            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                        }
                        currentState = this.applyRequest(currentState, request, indexMapperServices);
                        builder.success(request);
                    }
                    catch (Exception e) {
                        builder.failure(request, e);
                    }
                }
                ClusterStateTaskExecutor.ClusterTasksResult clusterTasksResult = builder.build(currentState);
                return clusterTasksResult;
            }
            finally {
                IOUtils.close(indexMapperServices.values());
            }
        }

        private ClusterState applyRequest(ClusterState currentState, PutMappingClusterStateUpdateRequest request, Map<Index, MapperService> indexMapperServices) throws IOException {
            String mappingType = request.type();
            CompressedXContent mappingUpdateSource = new CompressedXContent(request.source());
            Metadata metadata = currentState.metadata();
            ArrayList<IndexMetadata> updateList = new ArrayList<IndexMetadata>();
            for (Index index : request.indices()) {
                DocumentMapper newMapper;
                MapperService mapperService = indexMapperServices.get(index);
                IndexMetadata indexMetadata = currentState.getMetadata().getIndexSafe(index);
                updateList.add(indexMetadata);
                DocumentMapper existingMapper = mapperService.documentMapper();
                String typeForUpdate = mapperService.getTypeForUpdate(mappingType, mappingUpdateSource);
                if (existingMapper != null && !existingMapper.type().equals(typeForUpdate)) {
                    throw new IllegalArgumentException("Rejecting mapping update to [" + mapperService.index().getName() + "] as the final mapping would have more than 1 type: " + Arrays.asList(existingMapper.type(), typeForUpdate));
                }
                if ("_default_".equals(request.type())) {
                    newMapper = mapperService.parse(request.type(), mappingUpdateSource, false);
                } else {
                    newMapper = mapperService.parse(request.type(), mappingUpdateSource, existingMapper == null);
                    if (existingMapper != null) {
                        existingMapper.merge(newMapper.mapping());
                    }
                }
                if (mappingType == null) {
                    mappingType = newMapper.type();
                    continue;
                }
                if (mappingType.equals(newMapper.type()) || !MapperService.isMappingSourceTyped(request.type(), mappingUpdateSource) && mapperService.resolveDocumentType(mappingType).equals(newMapper.type())) continue;
                throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition.");
            }
            assert (mappingType != null);
            if (!"_default_".equals(mappingType) && !"_doc".equals(mappingType) && mappingType.charAt(0) == '_') {
                throw new InvalidTypeNameException("Document mapping type name can't start with '_', found: [" + mappingType + "]");
            }
            Metadata.Builder builder = Metadata.builder(metadata);
            boolean updated = false;
            for (IndexMetadata indexMetadata : updateList) {
                boolean updatedMapping = false;
                Index index = indexMetadata.getIndex();
                MapperService mapperService = indexMapperServices.get(index);
                String typeForUpdate = mapperService.getTypeForUpdate(mappingType, mappingUpdateSource);
                CompressedXContent existingSource = null;
                DocumentMapper existingMapper = mapperService.documentMapper(typeForUpdate);
                if (existingMapper != null) {
                    existingSource = existingMapper.mappingSource();
                }
                DocumentMapper mergedMapper = mapperService.merge(typeForUpdate, mappingUpdateSource, MapperService.MergeReason.MAPPING_UPDATE);
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (existingSource != null) {
                    if (!existingSource.equals(updatedSource)) {
                        updatedMapping = true;
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} update_mapping [{}] with source [{}]", (Object)index, (Object)mergedMapper.type(), (Object)updatedSource);
                        } else if (logger.isInfoEnabled()) {
                            logger.info("{} update_mapping [{}]", (Object)index, (Object)mergedMapper.type());
                        }
                    }
                } else {
                    updatedMapping = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} create_mapping [{}] with source [{}]", (Object)index, (Object)mappingType, (Object)updatedSource);
                    } else if (logger.isInfoEnabled()) {
                        logger.info("{} create_mapping [{}]", (Object)index, (Object)mappingType);
                    }
                }
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
                for (DocumentMapper mapper : Arrays.asList(mapperService.documentMapper(), mapperService.documentMapper("_default_"))) {
                    if (mapper == null) continue;
                    indexMetadataBuilder.putMapping(new MappingMetadata(mapper.mappingSource()));
                }
                if (updatedMapping) {
                    indexMetadataBuilder.mappingVersion(1L + indexMetadataBuilder.mappingVersion());
                }
                builder.put(indexMetadataBuilder);
                updated |= updatedMapping;
            }
            if (updated) {
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }

        @Override
        public String describeTasks(List<PutMappingClusterStateUpdateRequest> tasks) {
            return String.join((CharSequence)", ", tasks.stream().map(t -> t.type())::iterator);
        }
    }

    static class RefreshTask {
        final String index;
        final String indexUUID;

        RefreshTask(String index, String indexUUID) {
            this.index = index;
            this.indexUUID = indexUUID;
        }

        public String toString() {
            return "[" + this.index + "][" + this.indexUUID + "]";
        }
    }
}

