/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.UUIDs;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.transport.TransportAddress;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.node.Node;

public class DiscoveryNode
implements Writeable,
ToXContentFragment {
    static final String COORDINATING_ONLY = "coordinating_only";
    private final String nodeName;
    private final String nodeId;
    private final String ephemeralId;
    private final String hostName;
    private final String hostAddress;
    private final TransportAddress address;
    private final Map<String, String> attributes;
    private final Version version;
    private final SortedSet<DiscoveryNodeRole> roles;
    private static Map<String, DiscoveryNodeRole> roleNameToPossibleRoles;

    public static boolean nodeRequiresLocalStorage(Settings settings) {
        boolean localStorageEnable = Node.NODE_LOCAL_STORAGE_SETTING.get(settings);
        if (!localStorageEnable && (Node.NODE_DATA_SETTING.get(settings).booleanValue() || Node.NODE_MASTER_SETTING.get(settings).booleanValue())) {
            throw new IllegalArgumentException("storage can not be disabled for master and data nodes");
        }
        return localStorageEnable;
    }

    public static boolean isMasterNode(Settings settings) {
        return Node.NODE_MASTER_SETTING.get(settings);
    }

    public static boolean isDataNode(Settings settings) {
        return Node.NODE_DATA_SETTING.get(settings);
    }

    public static boolean isIngestNode(Settings settings) {
        return Node.NODE_INGEST_SETTING.get(settings);
    }

    public static boolean isRemoteClusterClient(Settings settings) {
        return Node.NODE_REMOTE_CLUSTER_CLIENT.get(settings);
    }

    public DiscoveryNode(String id, TransportAddress address, Version version) {
        this(id, address, Collections.emptyMap(), DiscoveryNodeRole.BUILT_IN_ROLES, version);
    }

    public DiscoveryNode(String id, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles, Version version) {
        this("", id, address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles, Version version) {
        this(nodeName, nodeId, UUIDs.randomBase64UUID(), address.address().getHostString(), address.getAddress(), address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, String ephemeralId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles, Version version) {
        this.nodeName = nodeName != null ? nodeName.intern() : "";
        this.nodeId = nodeId.intern();
        this.ephemeralId = ephemeralId.intern();
        this.hostName = hostName.intern();
        this.hostAddress = hostAddress.intern();
        this.address = address;
        this.version = version == null ? Version.CURRENT : version;
        this.attributes = Collections.unmodifiableMap(attributes);
        Predicate<Map> predicate = attrs -> {
            boolean success = true;
            for (DiscoveryNodeRole role : roleNameToPossibleRoles.values()) {
                assert (success &= !attrs.containsKey(role.roleName())) : role.roleName();
            }
            return success;
        };
        assert (predicate.test(attributes)) : attributes;
        this.roles = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(roles));
    }

    public static DiscoveryNode createLocal(Settings settings, TransportAddress publishAddress, String nodeId) {
        Map<String, String> attributes = Node.NODE_ATTRIBUTES.getAsMap(settings);
        Set<DiscoveryNodeRole> roles = DiscoveryNode.getRolesFromSettings(settings);
        return new DiscoveryNode(Node.NODE_NAME_SETTING.get(settings), nodeId, publishAddress, attributes, roles, Version.CURRENT);
    }

    public static Set<DiscoveryNodeRole> getRolesFromSettings(Settings settings) {
        return Collections.unmodifiableSet(roleNameToPossibleRoles.values().stream().filter(s -> s.roleSetting().get(settings)).collect(Collectors.toSet()));
    }

    public DiscoveryNode(StreamInput in) throws IOException {
        this.nodeName = in.readString().intern();
        this.nodeId = in.readString().intern();
        this.ephemeralId = in.readString().intern();
        this.hostName = in.readString().intern();
        this.hostAddress = in.readString().intern();
        this.address = new TransportAddress(in);
        int size = in.readVInt();
        this.attributes = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            this.attributes.put(in.readString(), in.readString());
        }
        int rolesSize = in.readVInt();
        HashSet<DiscoveryNodeRole> roles = new HashSet<DiscoveryNodeRole>(rolesSize);
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            for (int i = 0; i < rolesSize; ++i) {
                String roleName = in.readString();
                String roleNameAbbreviation = in.readString();
                DiscoveryNodeRole role = roleNameToPossibleRoles.get(roleName);
                if (role == null) {
                    roles.add(new DiscoveryNodeRole.UnknownRole(roleName, roleNameAbbreviation));
                    continue;
                }
                assert (roleName.equals(role.roleName())) : "role name [" + roleName + "] does not match role [" + role.roleName() + "]";
                assert (roleNameAbbreviation.equals(role.roleNameAbbreviation())) : "role name abbreviation [" + roleName + "] does not match role [" + role.roleNameAbbreviation() + "]";
                roles.add(role);
            }
        } else {
            block7: for (int i = 0; i < rolesSize; ++i) {
                LegacyRole legacyRole = in.readEnum(LegacyRole.class);
                switch (legacyRole) {
                    case MASTER: {
                        roles.add(DiscoveryNodeRole.MASTER_ROLE);
                        continue block7;
                    }
                    case DATA: {
                        roles.add(DiscoveryNodeRole.DATA_ROLE);
                        continue block7;
                    }
                    case INGEST: {
                        roles.add(DiscoveryNodeRole.INGEST_ROLE);
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)legacyRole.roleName());
                    }
                }
            }
        }
        this.roles = Collections.unmodifiableSortedSet(new TreeSet(roles));
        this.version = Version.readVersion(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.nodeId);
        out.writeString(this.ephemeralId);
        out.writeString(this.hostName);
        out.writeString(this.hostAddress);
        this.address.writeTo(out);
        out.writeVInt(this.attributes.size());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeVInt(this.roles.size());
            for (DiscoveryNodeRole role : this.roles) {
                out.writeString(role.roleName());
                out.writeString(role.roleNameAbbreviation());
            }
        } else {
            List rolesToWrite = this.roles.stream().filter(DiscoveryNodeRole.LEGACY_ROLES::contains).collect(Collectors.toList());
            out.writeVInt(rolesToWrite.size());
            for (DiscoveryNodeRole role : rolesToWrite) {
                if (role == DiscoveryNodeRole.MASTER_ROLE) {
                    out.writeEnum(LegacyRole.MASTER);
                    continue;
                }
                if (role == DiscoveryNodeRole.DATA_ROLE) {
                    out.writeEnum(LegacyRole.DATA);
                    continue;
                }
                if (role != DiscoveryNodeRole.INGEST_ROLE) continue;
                out.writeEnum(LegacyRole.INGEST);
            }
        }
        Version.writeVersion(this.version, out);
    }

    public TransportAddress getAddress() {
        return this.address;
    }

    public String getId() {
        return this.nodeId;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public String getName() {
        return this.nodeName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isDataNode() {
        return this.roles.contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public boolean isMasterNode() {
        return this.roles.contains(DiscoveryNodeRole.MASTER_ROLE);
    }

    public boolean isIngestNode() {
        return this.roles.contains(DiscoveryNodeRole.INGEST_ROLE);
    }

    public boolean isRemoteClusterClient() {
        return this.roles.contains(DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE);
    }

    public Set<DiscoveryNodeRole> getRoles() {
        return this.roles;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNode that = (DiscoveryNode)o;
        return this.ephemeralId.equals(that.ephemeralId);
    }

    public int hashCode() {
        return this.ephemeralId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeName.length() > 0) {
            sb.append('{').append(this.nodeName).append('}');
        }
        sb.append('{').append(this.nodeId).append('}');
        sb.append('{').append(this.ephemeralId).append('}');
        sb.append('{').append(this.hostName).append('}');
        sb.append('{').append(this.address).append('}');
        if (!this.roles.isEmpty()) {
            sb.append('{');
            this.roles.stream().map(DiscoveryNodeRole::roleNameAbbreviation).sorted().forEach(sb::append);
            sb.append('}');
        }
        if (!this.attributes.isEmpty()) {
            sb.append(this.attributes);
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getId());
        builder.field("name", this.getName());
        builder.field("ephemeral_id", this.getEphemeralId());
        builder.field("transport_address", this.getAddress().toString());
        builder.startObject("attributes");
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static void setPossibleRoles(Set<DiscoveryNodeRole> possibleRoles) {
        Map roleNameToPossibleRoles = Collections.unmodifiableMap(possibleRoles.stream().collect(Collectors.toMap(DiscoveryNodeRole::roleName, Function.identity())));
        Map roleNameAbbreviationToPossibleRoles = Collections.unmodifiableMap(roleNameToPossibleRoles.values().stream().collect(Collectors.toMap(DiscoveryNodeRole::roleNameAbbreviation, Function.identity())));
        assert (roleNameToPossibleRoles.size() == roleNameAbbreviationToPossibleRoles.size()) : "roles by name [" + roleNameToPossibleRoles + "], roles by name abbreviation [" + roleNameAbbreviationToPossibleRoles + "]";
        DiscoveryNode.roleNameToPossibleRoles = roleNameToPossibleRoles;
    }

    public static Set<String> getPossibleRoleNames() {
        return roleNameToPossibleRoles.keySet();
    }

    private static enum LegacyRole {
        MASTER("master"),
        DATA("data"),
        INGEST("ingest");

        private final String roleName;

        private LegacyRole(String roleName) {
            this.roleName = roleName;
        }

        public String roleName() {
            return this.roleName;
        }
    }
}

