/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRefIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.FutureObjects;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.AbstractBytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesArray;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesReference;

public final class CompositeBytesReference
extends AbstractBytesReference {
    private final BytesReference[] references;
    private final int[] offsets;
    private final int length;
    private final long ramBytesUsed;

    public CompositeBytesReference(BytesReference ... references) {
        this.references = Objects.requireNonNull(references, "references must not be null");
        this.offsets = new int[references.length];
        long ramBytesUsed = 0L;
        int offset = 0;
        for (int i = 0; i < references.length; ++i) {
            BytesReference reference = references[i];
            if (reference == null) {
                throw new IllegalArgumentException("references must not be null");
            }
            this.offsets[i] = offset;
            offset += reference.length();
            ramBytesUsed += reference.ramBytesUsed();
        }
        this.ramBytesUsed = ramBytesUsed + (long)(4 * this.offsets.length + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)(references.length * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + 4L + 8L;
        this.length = offset;
    }

    @Override
    public byte get(int index) {
        int i = this.getOffsetIndex(index);
        return this.references[i].get(index - this.offsets[i]);
    }

    @Override
    public int indexOf(byte marker, int from) {
        int firstReferenceIndex;
        int remainingBytes = Math.max(this.length - from, 0);
        FutureObjects.checkFromIndexSize(from, remainingBytes, this.length);
        int result = -1;
        if (this.length == 0) {
            return result;
        }
        for (int i = firstReferenceIndex = this.getOffsetIndex(from); i < this.references.length; ++i) {
            BytesReference reference = this.references[i];
            int internalFrom = i == firstReferenceIndex ? from - this.offsets[firstReferenceIndex] : 0;
            result = reference.indexOf(marker, internalFrom);
            if (result == -1) continue;
            result += this.offsets[i];
            break;
        }
        return result;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        FutureObjects.checkFromIndexSize(from, length, this.length);
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        int to = from + length;
        int limit = this.getOffsetIndex(to - 1);
        int start = this.getOffsetIndex(from);
        BytesReference[] inSlice = new BytesReference[1 + (limit - start)];
        int j = start;
        for (int i = 0; i < inSlice.length; ++i) {
            inSlice[i] = this.references[j++];
        }
        int inSliceOffset = from - this.offsets[start];
        if (inSlice.length == 1) {
            return inSlice[0].slice(inSliceOffset, length);
        }
        inSlice[0] = inSlice[0].slice(inSliceOffset, inSlice[0].length() - inSliceOffset);
        inSlice[inSlice.length - 1] = inSlice[inSlice.length - 1].slice(0, to - this.offsets[limit]);
        return new CompositeBytesReference(inSlice);
    }

    private int getOffsetIndex(int offset) {
        int i = Arrays.binarySearch(this.offsets, offset);
        return i < 0 ? -(i + 1) - 1 : i;
    }

    @Override
    public BytesRef toBytesRef() {
        BytesRefBuilder builder = new BytesRefBuilder();
        builder.grow(this.length());
        BytesRefIterator iterator = this.iterator();
        try {
            BytesRef spare;
            while ((spare = iterator.next()) != null) {
                builder.append(spare);
            }
        }
        catch (IOException ex) {
            throw new AssertionError("won't happen", ex);
        }
        return builder.toBytesRef();
    }

    @Override
    public BytesRefIterator iterator() {
        if (this.references.length > 0) {
            return new BytesRefIterator(){
                int index = 0;
                private BytesRefIterator current = CompositeBytesReference.access$000(CompositeBytesReference.this)[this.index++].iterator();

                @Override
                public BytesRef next() throws IOException {
                    BytesRef next = this.current.next();
                    if (next == null) {
                        while (this.index < CompositeBytesReference.this.references.length) {
                            this.current = CompositeBytesReference.this.references[this.index++].iterator();
                            next = this.current.next();
                            if (next == null) continue;
                            break;
                        }
                    }
                    return next;
                }
            };
        }
        return () -> null;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

