/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;

public class DocumentField
implements Writeable,
ToXContentFragment,
Iterable<Object> {
    private String name;
    private List<Object> values;

    public DocumentField(StreamInput in) throws IOException {
        this.name = in.readString();
        int size = in.readVInt();
        this.values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(in.readGenericValue());
        }
    }

    public DocumentField(String name, List<Object> values) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.values = Objects.requireNonNull(values, "values must not be null");
    }

    public String getName() {
        return this.name;
    }

    public <V> V getValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return (V)this.values.get(0);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean isMetadataField() {
        return MapperService.isMetadataField(this.name);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.values.size());
        for (Object obj : this.values) {
            out.writeGenericValue(obj);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(this.name);
        for (Object value : this.values) {
            builder.value(value);
        }
        builder.endArray();
        return builder;
    }

    public static DocumentField fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
        String fieldName = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser::getTokenLocation);
        ArrayList<Object> values = new ArrayList<Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            values.add(XContentParserUtils.parseFieldsValue(parser));
        }
        return new DocumentField(fieldName, values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentField objects = (DocumentField)o;
        return Objects.equals(this.name, objects.name) && Objects.equals(this.values, objects.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String toString() {
        return "DocumentField{name='" + this.name + '\'' + ", values=" + this.values + '}';
    }
}

