/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.LatLonDocValuesField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.LatLonPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BitUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Geometry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Point;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Rectangle;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.ShapeType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.utils.GeographyValidator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.utils.Geohash;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.utils.WellKnownText;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.GeoPointFieldMapper;

public final class GeoPoint
implements ToXContentFragment {
    private double lat;
    private double lon;

    public GeoPoint() {
    }

    public GeoPoint(String value) {
        this.resetFromString(value);
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint(GeoPoint template) {
        this(template.getLat(), template.getLon());
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetLat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoPoint resetLon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value) {
        return this.resetFromString(value, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
    }

    public GeoPoint resetFromString(String value, boolean ignoreZValue, GeoUtils.EffectivePoint effectivePoint) {
        if (value.toLowerCase(Locale.ROOT).contains("point")) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        if (value.contains(",")) {
            return this.resetFromCoordinates(value, ignoreZValue);
        }
        return this.parseGeoHash(value, effectivePoint);
    }

    public GeoPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double lon;
        double lat;
        String[] vals = value.split(",");
        if (vals.length > 3) {
            throw new ElasticsearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", vals.length);
        }
        try {
            lat = Double.parseDouble(vals[0].trim());
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("latitude must be a number", new Object[0]);
        }
        try {
            lon = Double.parseDouble(vals[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("longitude must be a number", new Object[0]);
        }
        if (vals.length > 2) {
            GeoPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
        }
        return this.reset(lat, lon);
    }

    private GeoPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = new WellKnownText(false, new GeographyValidator(ignoreZValue)).fromWKT(value);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid WKT format", (Throwable)e, new Object[0]);
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new ElasticsearchParseException("[geo_point] supports only POINT among WKT primitives, but found " + (Object)((Object)geometry.type()), new Object[0]);
        }
        Point point = (Point)geometry;
        return this.reset(point.getY(), point.getX());
    }

    GeoPoint parseGeoHash(String geohash, GeoUtils.EffectivePoint effectivePoint) {
        if (effectivePoint == GeoUtils.EffectivePoint.BOTTOM_LEFT) {
            return this.resetFromGeoHash(geohash);
        }
        Rectangle rectangle = Geohash.toBoundingBox(geohash);
        switch (effectivePoint) {
            case TOP_LEFT: {
                return this.reset(rectangle.getMaxY(), rectangle.getMinX());
            }
            case TOP_RIGHT: {
                return this.reset(rectangle.getMaxY(), rectangle.getMaxX());
            }
            case BOTTOM_RIGHT: {
                return this.reset(rectangle.getMinY(), rectangle.getMaxX());
            }
        }
        throw new IllegalArgumentException("Unsupported effective point " + (Object)((Object)effectivePoint));
    }

    public GeoPoint resetFromIndexHash(long hash) {
        this.lon = Geohash.decodeLongitude(hash);
        this.lat = Geohash.decodeLatitude(hash);
        return this;
    }

    public GeoPoint resetFromIndexableField(IndexableField field) {
        if (field instanceof LatLonPoint) {
            BytesRef br = field.binaryValue();
            byte[] bytes = Arrays.copyOfRange(br.bytes, br.offset, br.length);
            return this.reset(GeoEncodingUtils.decodeLatitude(bytes, 0), GeoEncodingUtils.decodeLongitude(bytes, 4));
        }
        if (field instanceof LatLonDocValuesField) {
            long encoded = (Long)field.numericValue();
            return this.reset(GeoEncodingUtils.decodeLatitude((int)(encoded >>> 32)), GeoEncodingUtils.decodeLongitude((int)encoded));
        }
        return this.resetFromIndexHash(Long.parseLong(field.stringValue()));
    }

    public GeoPoint resetFromGeoHash(String geohash) {
        long hash;
        try {
            hash = Geohash.mortonEncode(geohash);
        }
        catch (IllegalArgumentException ex) {
            throw new ElasticsearchParseException(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        return this.reset(Geohash.decodeLatitude(hash), Geohash.decodeLongitude(hash));
    }

    public GeoPoint resetFromGeoHash(long geohashLong) {
        int level = (int)(12L - (geohashLong & 0xFL));
        return this.resetFromIndexHash(BitUtil.flipFlop(geohashLong >>> 4 << level * 5 + 2));
    }

    public double lat() {
        return this.lat;
    }

    public double getLat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double getLon() {
        return this.lon;
    }

    public String geohash() {
        return Geohash.stringEncode(this.lon, this.lat);
    }

    public String getGeohash() {
        return Geohash.stringEncode(this.lon, this.lat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = Long.hashCode(temp);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + Long.hashCode(temp);
        return result;
    }

    public String toString() {
        return this.lat + ", " + this.lon;
    }

    public static GeoPoint fromGeohash(String geohash) {
        return new GeoPoint().resetFromGeoHash(geohash);
    }

    public static GeoPoint fromGeohash(long geohashLong) {
        return new GeoPoint().resetFromGeoHash(geohashLong);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.latlon(this.lat, this.lon);
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [{}] parameter is [{}]", zValue, GeoPointFieldMapper.Names.IGNORE_Z_VALUE, ignoreZValue);
        }
        return zValue;
    }
}

