/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Collections;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.SloppyMath;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoDistance;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.DistanceUnit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentSubParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.support.MapXContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.FieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.GeoPointValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.SortingNumericDoubleValues;

public class GeoUtils {
    public static final double MAX_LAT = 90.0;
    public static final double MIN_LAT = -90.0;
    public static final double MAX_LON = 180.0;
    public static final double MIN_LON = -180.0;
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";
    public static final String GEOHASH = "geohash";
    public static final double EARTH_SEMI_MAJOR_AXIS = 6378137.0;
    public static final double EARTH_SEMI_MINOR_AXIS = 6356752.314245;
    public static final double EARTH_MEAN_RADIUS = 6371008.7714;
    public static final double EARTH_AXIS_RATIO = 0.9966471893352243;
    public static final double EARTH_EQUATOR = 4.007501668557849E7;
    public static final double EARTH_POLAR_DISTANCE = 1.9970326371122006E7;
    public static final double TOLERANCE = 1.0E-6;

    public static boolean isValidLatitude(double latitude) {
        return !Double.isNaN(latitude) && !Double.isInfinite(latitude) && !(latitude < -90.0) && !(latitude > 90.0);
    }

    public static boolean isValidLongitude(double longitude) {
        return !Double.isNaN(longitude) && !Double.isInfinite(longitude) && !(longitude < -180.0) && !(longitude > 180.0);
    }

    public static double geoHashCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << (level + 1) / 2 * 3 + level / 2 * 2);
    }

    public static double quadTreeCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << level);
    }

    public static double geoHashCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << (level + 1) / 2 * 2 + level / 2 * 3);
    }

    public static double quadTreeCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << level);
    }

    public static double geoHashCellSize(int level) {
        assert (level >= 0);
        double w = GeoUtils.geoHashCellWidth(level);
        double h = GeoUtils.geoHashCellHeight(level);
        return Math.sqrt(w * w + h * h);
    }

    public static double quadTreeCellSize(int level) {
        assert (level >= 0);
        return Math.sqrt(2.0048208977185252E15) / (double)(1L << level);
    }

    public static int quadTreeLevelsForPrecision(double meters) {
        int level;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return 50;
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        long part = Math.round(Math.ceil(4.007501668557849E7 / width));
        return part <= 1L << (level = 64 - Long.numberOfLeadingZeros(part) - 1) ? level : level + 1;
    }

    public static int quadTreeLevelsForPrecision(String distance) {
        return GeoUtils.quadTreeLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static int geoHashLevelsForPrecision(double meters) {
        int full;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return GeohashPrefixTree.getMaxLevelsPossible();
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        double part = Math.ceil(4.007501668557849E7 / width);
        if (part == 1.0) {
            return 1;
        }
        int bits = (int)Math.round(Math.ceil(Math.log(part) / Math.log(2.0)));
        int left = bits - (full = bits / 5) * 5;
        int even = full + (left > 0 ? 1 : 0);
        int odd = full + (left > 3 ? 1 : 0);
        return even + odd;
    }

    public static int geoHashLevelsForPrecision(String distance) {
        return GeoUtils.geoHashLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static double normalizeLon(double lon) {
        if (lon > 180.0 || lon <= -180.0) {
            lon = GeoUtils.centeredModulus(lon, 360.0);
        }
        return lon + 0.0;
    }

    public static double normalizeLat(double lat) {
        if (lat > 90.0 || lat < -90.0) {
            if ((lat = GeoUtils.centeredModulus(lat, 360.0)) < -90.0) {
                lat = -180.0 - lat;
            } else if (lat > 90.0) {
                lat = 180.0 - lat;
            }
        }
        return lat + 0.0;
    }

    public static void normalizePoint(GeoPoint point) {
        GeoUtils.normalizePoint(point, true, true);
    }

    public static void normalizePoint(GeoPoint point, boolean normLat, boolean normLon) {
        double[] pt = new double[]{point.lon(), point.lat()};
        GeoUtils.normalizePoint(pt, normLon, normLat);
        point.reset(pt[1], pt[0]);
    }

    public static void normalizePoint(double[] lonLat) {
        GeoUtils.normalizePoint(lonLat, true, true);
    }

    public static void normalizePoint(double[] lonLat, boolean normLon, boolean normLat) {
        assert (lonLat != null && lonLat.length == 2);
        normLat = normLat && (lonLat[1] > 90.0 || lonLat[1] < -90.0);
        boolean bl = normLon = normLon && (lonLat[0] > 180.0 || lonLat[0] < -180.0 || normLat);
        if (normLat) {
            lonLat[1] = GeoUtils.centeredModulus(lonLat[1], 360.0);
            boolean shift = true;
            if (lonLat[1] < -90.0) {
                lonLat[1] = -180.0 - lonLat[1];
            } else if (lonLat[1] > 90.0) {
                lonLat[1] = 180.0 - lonLat[1];
            } else {
                shift = false;
            }
            if (shift) {
                lonLat[0] = normLon ? lonLat[0] + 180.0 : lonLat[0] + (GeoUtils.normalizeLon(lonLat[0]) > 0.0 ? -180.0 : 180.0);
            }
        }
        if (normLon) {
            lonLat[0] = GeoUtils.centeredModulus(lonLat[0], 360.0);
        }
    }

    public static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }

    public static GeoPoint parseGeoPoint(XContentParser parser) throws IOException, ElasticsearchParseException {
        return GeoUtils.parseGeoPoint(parser, new GeoPoint());
    }

    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point) throws IOException, ElasticsearchParseException {
        return GeoUtils.parseGeoPoint(parser, point, false);
    }

    public static GeoPoint parseGeoPoint(Object value, boolean ignoreZValue) throws ElasticsearchParseException {
        GeoPoint geoPoint;
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("null_value", value), null);
        try {
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            geoPoint = GeoUtils.parseGeoPoint(parser, new GeoPoint(), ignoreZValue);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ElasticsearchParseException("error parsing geopoint", (Throwable)ex, new Object[0]);
            }
        }
        parser.close();
        return geoPoint;
    }

    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        return GeoUtils.parseGeoPoint(parser, point, ignoreZValue, EffectivePoint.BOTTOM_LEFT);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point, boolean ignoreZValue, EffectivePoint effectivePoint) throws IOException, ElasticsearchParseException {
        block33: {
            lat = NaN;
            lon = NaN;
            geohash = null;
            numberFormatException = null;
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) break block33;
            subParser = new XContentSubParser(parser);
            ** GOTO lbl16
        }
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            if (parser.currentToken() != XContentParser.Token.VALUE_STRING) throw new ElasticsearchParseException("geo_point expected", new Object[0]);
            val = parser.text();
            return point.resetFromString(val, ignoreZValue, effectivePoint);
        }
        subParser = new XContentSubParser(parser);
        try {
            block34: {
                break block34;
lbl16:
                // 1 sources

                try {
                    block20: while (subParser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if (subParser.currentToken() != XContentParser.Token.FIELD_NAME) {
                            throw new ElasticsearchParseException("token [{}] not allowed", new Object[]{subParser.currentToken()});
                        }
                        field = subParser.currentName();
                        if ("lat".equals(field)) {
                            subParser.nextToken();
                            switch (3.$SwitchMap$org$elasticsearch$common$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                                case 1: 
                                case 2: {
                                    try {
                                        lat = subParser.doubleValue(true);
                                    }
                                    catch (NumberFormatException e) {
                                        numberFormatException = e;
                                    }
                                    continue block20;
                                }
                            }
                            throw new ElasticsearchParseException("latitude must be a number", new Object[0]);
                        }
                        if ("lon".equals(field)) {
                            subParser.nextToken();
                            switch (3.$SwitchMap$org$elasticsearch$common$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                                case 1: 
                                case 2: {
                                    try {
                                        lon = subParser.doubleValue(true);
                                    }
                                    catch (NumberFormatException e) {
                                        numberFormatException = e;
                                    }
                                    continue block20;
                                }
                            }
                            throw new ElasticsearchParseException("longitude must be a number", new Object[0]);
                        }
                        if (!"geohash".equals(field)) {
                            throw new ElasticsearchParseException("field must be either [{}], [{}] or [{}]", new Object[]{"lat", "lon", "geohash"});
                        }
                        if (subParser.nextToken() != XContentParser.Token.VALUE_STRING) throw new ElasticsearchParseException("geohash must be a string", new Object[0]);
                        geohash = subParser.text();
                    }
                }
                finally {
                    subParser.close();
                }
                if (geohash != null) {
                    if (Double.isNaN(lat) == false) throw new ElasticsearchParseException("field must be either lat/lon or geohash", new Object[0]);
                    if (Double.isNaN(lon) != false) return point.parseGeoHash(geohash, effectivePoint);
                    throw new ElasticsearchParseException("field must be either lat/lon or geohash", new Object[0]);
                }
                if (numberFormatException != null) {
                    throw new ElasticsearchParseException("[{}] and [{}] must be valid double values", numberFormatException, new Object[]{"lat", "lon"});
                }
                if (Double.isNaN(lat)) {
                    throw new ElasticsearchParseException("field [{}] missing", new Object[]{"lat"});
                }
                if (Double.isNaN(lon) == false) return point.reset(lat, lon);
                throw new ElasticsearchParseException("field [{}] missing", new Object[]{"lon"});
            }
            element = 0;
            while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (subParser.currentToken() != XContentParser.Token.VALUE_NUMBER) throw new ElasticsearchParseException("numeric value expected", new Object[0]);
                if (++element == 1) {
                    lon = subParser.doubleValue();
                    continue;
                }
                if (element == 2) {
                    lat = subParser.doubleValue();
                    continue;
                }
                if (element != 3) throw new ElasticsearchParseException("[geo_point] field type does not accept > 3 dimensions", new Object[0]);
                GeoPoint.assertZValue(ignoreZValue, subParser.doubleValue());
            }
            return point.reset(lat, lon);
        }
        finally {
            subParser.close();
        }
    }

    public static GeoPoint parseFromString(String val) {
        GeoPoint point = new GeoPoint();
        return point.resetFromString(val, false, EffectivePoint.BOTTOM_LEFT);
    }

    public static int parsePrecision(XContentParser parser) throws IOException, ElasticsearchParseException {
        XContentParser.Token token = parser.currentToken();
        if (token.equals((Object)XContentParser.Token.VALUE_NUMBER)) {
            return XContentMapValues.nodeIntegerValue(parser.intValue());
        }
        String precision = parser.text();
        try {
            return XContentMapValues.nodeIntegerValue(precision);
        }
        catch (NumberFormatException e) {
            int parsedPrecision = GeoUtils.geoHashLevelsForPrecision(precision);
            try {
                return GeoUtils.checkPrecisionRange(parsedPrecision);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("precision too high [" + precision + "]", e2);
            }
        }
    }

    public static int checkPrecisionRange(int precision) {
        if (precision < 1 || precision > 12) {
            throw new IllegalArgumentException("Invalid geohash aggregation precision of " + precision + ". Must be between 1 and 12.");
        }
        return precision;
    }

    public static double maxRadialDistanceMeters(double centerLat, double centerLon) {
        if (Math.abs(centerLat) == 90.0) {
            return SloppyMath.haversinMeters(centerLat, centerLon, 0.0, centerLon);
        }
        return SloppyMath.haversinMeters(centerLat, centerLon, centerLat, (180.0 + centerLon) % 360.0);
    }

    public static double arcDistance(double lat1, double lon1, double lat2, double lon2) {
        return SloppyMath.haversinMeters(lat1, lon1, lat2, lon2);
    }

    public static double planeDistance(double lat1, double lon1, double lat2, double lon2) {
        double x = (lon2 - lon1) * (Math.PI / 180) * Math.cos((lat2 + lat1) / 2.0 * (Math.PI / 180));
        double y = (lat2 - lat1) * (Math.PI / 180);
        return Math.sqrt(x * x + y * y) * 6371008.7714;
    }

    public static SortedNumericDoubleValues distanceValues(final GeoDistance distance, final DistanceUnit unit, final MultiGeoPointValues geoPointValues, final GeoPoint ... fromPoints) {
        final GeoPointValues singleValues = FieldData.unwrapSingleton(geoPointValues);
        if (singleValues != null && fromPoints.length == 1) {
            return FieldData.singleton(new NumericDoubleValues(){

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return singleValues.advanceExact(doc);
                }

                @Override
                public double doubleValue() throws IOException {
                    GeoPoint from = fromPoints[0];
                    GeoPoint to = singleValues.geoPointValue();
                    return distance.calculate(from.lat(), from.lon(), to.lat(), to.lon(), unit);
                }
            });
        }
        return new SortingNumericDoubleValues(){

            @Override
            public boolean advanceExact(int target) throws IOException {
                if (geoPointValues.advanceExact(target)) {
                    this.resize(geoPointValues.docValueCount() * fromPoints.length);
                    int v = 0;
                    for (int i = 0; i < geoPointValues.docValueCount(); ++i) {
                        GeoPoint point = geoPointValues.nextValue();
                        for (GeoPoint from : fromPoints) {
                            this.values[v] = distance.calculate(from.lat(), from.lon(), point.lat(), point.lon(), unit);
                            ++v;
                        }
                    }
                    this.sort();
                    return true;
                }
                return false;
            }
        };
    }

    private GeoUtils() {
    }

    public static enum EffectivePoint {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

