/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings;

import java.nio.file.Path;
import org.graylog.shaded.elasticsearch7.joptsimple.OptionSet;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cli.KeyStoreAwareCommand;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cli.UserException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.KeyStoreWrapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.env.Environment;

public class HasPasswordKeyStoreCommand
extends KeyStoreAwareCommand {
    static final int NO_PASSWORD_EXIT_CODE = 1;

    HasPasswordKeyStoreCommand() {
        super("Succeeds if the keystore exists and is password-protected, fails with exit code 1 otherwise.");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Path configFile = env.configFile();
        KeyStoreWrapper keyStore = KeyStoreWrapper.load(configFile);
        if (keyStore == null) {
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "ERROR: Elasticsearch keystore not found");
            throw new UserException(1, null);
        }
        if (!keyStore.hasPassword()) {
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "ERROR: Keystore is not password-protected");
            throw new UserException(1, null);
        }
        terminal.println(Terminal.Verbosity.NORMAL, "Keystore is password-protected");
    }
}

