/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.Scheduler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncTask
implements Runnable,
Closeable {
    private final Logger logger;
    private final ThreadPool threadPool;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final boolean autoReschedule;
    private volatile Scheduler.Cancellable cancellable;
    private volatile boolean isScheduledOrRunning;
    private volatile Exception lastThrownException;
    private volatile TimeValue interval;

    protected AbstractAsyncTask(Logger logger, ThreadPool threadPool, TimeValue interval, boolean autoReschedule) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.interval = interval;
        this.autoReschedule = autoReschedule;
    }

    public synchronized void setInterval(TimeValue interval) {
        this.interval = interval;
        if (this.cancellable != null) {
            this.rescheduleIfNecessary();
        }
    }

    public TimeValue getInterval() {
        return this.interval;
    }

    protected abstract boolean mustReschedule();

    public synchronized void rescheduleIfNecessary() {
        if (this.isClosed()) {
            return;
        }
        if (this.cancellable != null) {
            this.cancellable.cancel();
        }
        if (this.interval.millis() > 0L && this.mustReschedule()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("scheduling {} every {}", (Object)this.toString(), (Object)this.interval);
            }
            this.cancellable = this.threadPool.schedule(this, this.interval, this.getThreadPool());
            this.isScheduledOrRunning = true;
        } else {
            this.logger.trace("scheduled {} disabled", (Object)this.toString());
            this.cancellable = null;
            this.isScheduledOrRunning = false;
        }
    }

    public boolean isScheduled() {
        return this.isScheduledOrRunning;
    }

    public synchronized void cancel() {
        if (this.cancellable != null) {
            this.cancellable.cancel();
            this.cancellable = null;
        }
        this.isScheduledOrRunning = false;
    }

    @Override
    public synchronized void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.cancel();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        AbstractAsyncTask abstractAsyncTask = this;
        synchronized (abstractAsyncTask) {
            if (this.isClosed()) {
                return;
            }
            this.cancellable = null;
            this.isScheduledOrRunning = this.autoReschedule;
        }
        try {
            this.runInternal();
        }
        catch (Exception ex) {
            if (this.lastThrownException == null || !AbstractAsyncTask.sameException(this.lastThrownException, ex)) {
                this.logger.warn(() -> new ParameterizedMessage("failed to run task {} - suppressing re-occurring exceptions unless the exception changes", (Object)this.toString()), (Throwable)ex);
                this.lastThrownException = ex;
            }
        }
        finally {
            if (this.autoReschedule) {
                this.rescheduleIfNecessary();
            }
        }
    }

    private static boolean sameException(Exception left, Exception right) {
        StackTraceElement[] stackTraceRight;
        StackTraceElement[] stackTraceLeft;
        if (left.getClass() == right.getClass() && Objects.equals(left.getMessage(), right.getMessage()) && (stackTraceLeft = left.getStackTrace()).length == (stackTraceRight = right.getStackTrace()).length) {
            for (int i = 0; i < stackTraceLeft.length; ++i) {
                if (stackTraceLeft[i].equals(stackTraceRight[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract void runInternal();

    protected String getThreadPool() {
        return "same";
    }
}

